/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogSemenService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Controller
@RequestMapping(value = "/api/v1/dog/dogSemen")
public class RestDogSemenController extends BaseRestController {

    @Autowired
    private RestDogSemenService restDogSemenService;

    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    public void get(@PathVariable("id") String id, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restDogSemenService.get(id);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "", method = RequestMethod.GET)
    public void getList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restDogSemenService.getList(request);
        ServletUtils.writeResponse(response, result);
    }
}