/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestPersonnelService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 犬只信息管理Controller
 *
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/cku/v1/personnel")
public class AppPersonnelController extends BaseRestController {

	@Autowired
	private RestPersonnelService restPersonnelService;

	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getByKey(HttpServletRequest request,
						 HttpServletResponse response) throws IOException {
		RESTResponse result = restPersonnelService.getByKey(request);
		ServletUtils.writeResponse(response, result);
	}

}