/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.contest.model;

import com.cku.oa.contest.entity.ContestJudgeTypeClass;

/**
 * 赛制年龄组别对照Entity
 * @author yuanshuai
 * @version 2020-11-05
 */
public class RestContestJudgeTypeClass {
	
	private static final long serialVersionUID = 1L;
	private String judge_type;		// judge_type
	private String class_no;		// class_no
	private String code;		// code
	private String name;		// name
	private String sort_no;		// sort_no
	
	public RestContestJudgeTypeClass() {
		super();
	}

	public RestContestJudgeTypeClass(ContestJudgeTypeClass judgeTypeClass) {
		this.judge_type = judgeTypeClass.getJudgeType();
		this.class_no = judgeTypeClass.getClassNo();
		this.code = judgeTypeClass.getCode();
		this.name = judgeTypeClass.getName();
		this.sort_no = judgeTypeClass.getSortNo();
	}

	public String getJudge_type() {
		return judge_type;
	}

	public void setJudge_type(String judge_type) {
		this.judge_type = judge_type;
	}

	public String getClass_no() {
		return class_no;
	}

	public void setClass_no(String class_no) {
		this.class_no = class_no;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSort_no() {
		return sort_no;
	}

	public void setSort_no(String sort_no) {
		this.sort_no = sort_no;
	}
}