package com.cku.restful.v1.contest.model;

import com.cku.oa.show.entity.ChildShows;

import java.util.Date;

/**
 * 赛场犬种Entity
 * @author yuanshuai
 * @version 2020-10-12
 */
public class RestContest {

	private String contest_no;
	private String title;
	private Date date_contest;
	private Integer sort_no;
	private String judge_type;
	private String judge_type_no;
	private String contest_event_no;
	private Date date_added;

	public RestContest() {
	}

	public RestContest(ChildShows childShows) {
		contest_no = childShows.getId();
		title = childShows.getShowName();
		date_contest = childShows.getStartTime();
		judge_type = childShows.getContestJudgeType();
		judge_type_no = "0";
		contest_event_no = childShows.getMainShowId();
		date_added = childShows.getCreateDate();
		String[] showCode = childShows.getShowCode().split("-");
		sort_no = Integer.parseInt(showCode[showCode.length-1]);
	}

	public String getContest_no() {
		return contest_no;
	}

	public void setContest_no(String contest_no) {
		this.contest_no = contest_no;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Date getDate_contest() {
		return date_contest;
	}

	public void setDate_contest(Date date_contest) {
		this.date_contest = date_contest;
	}

	public Integer getSort_no() {
		return sort_no;
	}

	public void setSort_no(Integer sort_no) {
		this.sort_no = sort_no;
	}

	public String getJudge_type() {
		return judge_type;
	}

	public void setJudge_type(String judge_type) {
		this.judge_type = judge_type;
	}

	public String getJudge_type_no() {
		return judge_type_no;
	}

	public void setJudge_type_no(String judge_type_no) {
		this.judge_type_no = judge_type_no;
	}

	public String getContest_event_no() {
		return contest_event_no;
	}

	public void setContest_event_no(String contest_event_no) {
		this.contest_event_no = contest_event_no;
	}

	public Date getDate_added() {
		return date_added;
	}

	public void setDate_added(Date date_added) {
		this.date_added = date_added;
	}
}