package com.cku.oa.sys.service;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.sys.dao.RemindDao;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.Remind;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.GroomerMemberService;
import com.cku.oa.sys.util.ZtSmsUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 业务提醒功能Service
 * @author fanhuibin
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class RemindService extends CrudService<RemindDao, Remind> {
	private static final String MESSAGE_LEFT = "";

	@Autowired
	private MemberDao memberDao;


	public Remind get(String id) {
		return super.get(id);
	}

	public List<Remind> findList(Remind remind) {
		return super.findList(remind);
	}

	public Page<Remind> findPage(Page<Remind> page, Remind remind) {
		return super.findPage(page, remind);
	}

	@Transactional(readOnly = false)
	public void save(Remind remind) {
		super.save(remind);
	}

	@Transactional(readOnly = false)
	public void delete(Remind remind) {
		super.delete(remind);
	}

	/**
	 * 发送消息的计划任务，美容师会员倒计三天提醒
	 * 使用quartZ在每天触发，处理计划任务中的消息功能
	 */
	@Transactional(readOnly = false)
	public void remindTask(){
		List<Member> groomerMemeberList = memberDao.getGroomerMemeberList(3);
		for (Member member : groomerMemeberList) {
			String date = DateFormatUtils.format(member.getGroomerEndDate(), "yyyy年M月d日");
			StringBuffer sb = new StringBuffer();
			sb.append("您CKU美容师的会员资质将于").append(date).append("到期，请您及时续费。");
			addRemind(sb.toString(),member.getMemberCode());
		}
	}

	/**
	 * 会员中心消息提醒--(美容 培训已用)
	 * @Author chaixueteng
	 * @2016年12月28日下午3:14:14
	 */
	@Transactional(readOnly = false)
	public void addMemberRemind(String content,String memberCode){
		Member member = memberDao.getByMemberCode(memberCode);
	 	if (member.getUser()!=null) {
	 		String userId = member.getUser().getId();
	 		if(userId != null && !userId.equals("")){
	 			User user = new User();
	 			user.setId(userId);

	 			Remind remind = new Remind();
	 			remind.setContent(content);
	 			remind.setUser(user);
	 			remind.setReadFlag("0");
	 			remind.preInsert();
	 			dao.insert(remind);
	 		}
		}
	}

	/**
	 * 会员中心消息提醒--(美容 培训已用)
	 * @Author chaixueteng
	 * @2016年12月28日下午3:14:14
	 */
	@Transactional(readOnly = false)
	public void addKennelRemind(String content,String memberCode){
		Member member = memberDao.getByMemberCode(memberCode);
	 	if (member.getUser()!=null) {
	 		String userId = member.getUser().getId();
	 		if(userId != null && !userId.equals("")){
	 			User user = new User();
	 			user.setId(userId);

	 			Remind remind = new Remind();
	 			remind.setContent(content);
	 			remind.setUser(user);
	 			remind.setReadFlag("0");
	 			remind.setId(IdGen.uuid());
	 			remind.setCreateBy(user);
	 			remind.setUpdateBy(user);
	 			remind.setUpdateDate(new Date());
	 			remind.setCreateDate(new Date());
	 			remind.setDelFlag("0");
	 			dao.insert(remind);
	 		}
		}
	}

	/**
	 * 给用户推送业务处理消息
	 * @param content 要发送的消息，不需要带用户消息敬称与消息签名
	 * 				  比如  “【宠爱王国】尊敬的会员，”  只发送 “您的资格证书已经生成，请注意查收邮寄证书。”
	 * @param memberCode 办理业务的会员的会员号
	 */
	@Transactional(readOnly = false)
	public void addRemind(String content,String memberCode){

		//由于业务方面有问题，暂时禁用，
		//会员一次办理多个业务，会导致用户连续收到几十条短信的情况
//		//先获取用户信息
	 /*	Member member = memberDao.getByMemberCode(memberCode);
	 	if (member.getUser()!=null) {
	 		String userId = member.getUser().getId();
	 		if(userId != null && !userId.equals("")){
	 			User user = new User();
	 			user.setId(userId);

	 			Remind remind = new Remind();
	 			remind.setContent(content);
	 			remind.setUser(user);
	 			remind.setReadFlag("0");
	 			remind.preInsert();
	 			dao.insert(remind);
	 		}
		}*/
//	 	ZtSmsUtil.sendNote(content, member.getMobile());
	}

	/**
	 *
	 * @description: 标记消息为已读
	 * @author: laiguanglong
	 * @date: 2016年9月13日 上午11:25:46
	 */
	@Transactional(readOnly = false)
	public void updateReadFlag(){
		User user = UserUtils.getLoginUser();
		Date date = new Date();
		Remind remind = new Remind();
		remind.setUser(user);
		remind.setReadDate(date);
		remind.setReadFlag("1");
		remind.setUpdateBy(user);
		remind.setUpdateDate(date);
		dao.updateReadFlag(remind);
	}
}