package com.cku.oa.sys.service;

import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogNewbornService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service
@Transactional(readOnly = true)
public class AutoAuditService {

	@Autowired
	private DogNewbornDao dogNewbornDao;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;


	/**
	 * @description: 定时自动审核业务
	 * @author: laiguanglong
	 * @date: 2017/2/8 11:26
	 */
	@Transactional(readOnly = false)
	public void autoAudit(){
		//配种证明自动审核
		dogNewbornAutoAudit();
		//出生证明自动审核
		dogBirthCertificateAutoAudit();
	}

	/**
	 * @description: 配种证明自动审核
	 * @author: laiguanglong
	 * @date: 2017/2/8 11:35
	 */
	@Transactional(readOnly = false)
	public int dogNewbornAutoAudit(){
		int count = 0;
		//3天前时间
		Date date = getXDate(-3);
		//查询待自动审核数据
		List<DogNewborn> dogNewbornList = dogNewbornDao.findUnReviewByPayDate(date);
		for(DogNewborn dogNewborn:dogNewbornList){
			try {
				dogNewbornService.autoAudit(dogNewborn);
				count++;
			}catch (Exception e){
				continue;
			}
		}
		return count;
	}

	/**
	 * @description: 出生证明自动审核
	 * @author: laiguanglong
	 * @date: 2017/2/8 11:35
	 */
	@Transactional(readOnly = false)
	public int dogBirthCertificateAutoAudit(){
		int count = 0;
		//3天前时间
		Date date = getXDate(-3);
		//查询待自动审核的配种证明编号
		List<String> fmdogBreedCertifiedCodeList = dogBirthCertificateDao.findUnReviewByPayDate(date);
		for(String fmdogBreedCertifiedCode:fmdogBreedCertifiedCodeList){
			try {
				//根据配种证明编号查询1条出生纸进行审核
				DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getOneByFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
				dogBirthCertificateService.autoAudit(dogBirthCertificate);
				count++;
			}catch (Exception e){
				continue;
			}
		}
		return count;
	}

	/**
	 * @description: 获取距离现在x天的0时0分0秒的Date对象
	 * @author: laiguanglong
	 * @date: 2017/2/8 14:23
	 */
	private Date getXDate(int x){
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.DATE, x); //日期加1
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String dateString = sdf.format(calendar.getTime());
		Date date = null;
		try {
			date = sdf.parse(dateString);
		}catch (Exception e){
			return null;
		}
		return date;
	}
}