package com.cku.oa.statistics.web;

import com.cku.oa.statistics.dao.ClubStatisticsDao;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.Collections3;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.*;

/**
 * 商城统计
 *user chaixueteng
 *2016年12月19日
 */
@Controller
@RequestMapping(value = "${adminPath}/statistics/club")
public class ClubStatisticsController {

	@Autowired
	public ClubStatisticsDao clubStatisticsDao;

	/**
	 * 商城销售统计
	 * @throws ParseException
	 */
	@RequestMapping(value = "clubStatistics")
	public String shopStatistics(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
			String name=request.getParameter("name");
			String state=request.getParameter("state");
			String area = request.getParameter("area");
			if(area!=null&&area.equals("all")){
				area=null;
			}
			if(state==null)
			{
				state="0";
			}
			String nowDate=request.getParameter("nowDate");
			if(nowDate==null)
			{
				nowDate="";
			}
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			if(!nowDate.equals(""))
			{
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00:";
					endDate = String.valueOf(year)+"-12-31 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
				}
			}else{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
			}
			//统计商品每个品种的销售信息
			List<Map> results = new ArrayList<Map>();
			if(startDate.compareTo("2017-06-01 00:00:00")>=0)
			{
				results = clubStatisticsDao.countByNewDate(startDate, endDate, name, state, area);

			}else if(startDate.compareTo("2017-06-01 00:00:00")<0 && endDate.compareTo("2017-06-01 00:00:00")<0){

				results = clubStatisticsDao.countByDate(startDate,endDate,name,state, area);

			}else if(startDate.compareTo("2017-06-01 00:00:00")<0 && endDate.compareTo("2017-06-01 00:00:00")>0){

				results = clubStatisticsDao.countAll(startDate,endDate,name,state, area);

			}
			if(area == null)
			{
				area="all";
			}
			model.addAttribute("results",results);
			model.addAttribute("size",results.size());
			model.addAttribute("startDate",startDate);
			model.addAttribute("endDate",endDate);
			model.addAttribute("name",name);
			model.addAttribute("state",state);
			model.addAttribute("area",area);
			model.addAttribute("date",new Date());
			Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
			 //你这个功能根本不需要分页，我就不给你差总条数了，自己看着办吧。
			page.setCount(results.size());
			page.initialize();//重新计算页码信息
			model.addAttribute("page",page);
			return "oa/statistics/org/clubStatistics";

	}

	/**
	 * @Description： 单犬种地方俱乐部统计
	 * @author: yuanshuai
	 * @date: 2019/10/17 14:55
	 */
	@RequestMapping(value = "clubStatistics/singleType")
	public String singleTypeClubStatistics(HttpServletRequest request, HttpServletResponse response, Model model) throws ParseException {
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String name = request.getParameter("name");
		String state = request.getParameter("state");
		String area = request.getParameter("area");
		if (area != null && area.equals("all")) {
			area = null;
		}
		if (state == null) {
			state = "0";
		}
		String nowDate = request.getParameter("nowDate");
		if (nowDate == null) {
			nowDate = "";
		}
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if (!nowDate.equals("")) {
			if (nowDate.equals("year")) {
				startDate = String.valueOf(year) + "-01-01 00:00:00:";
				endDate = String.valueOf(year) + "-12-31 23:59:59";
			} else if (nowDate.equals("month")) {
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-01 00:00:00";
				endDate = String.valueOf(year) + "-" + String.valueOf(month + 1) + "-01 23:59:59";
			}
		} else {
			if (startDate == null || startDate.equals(""))
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 00:00:00";
			if (endDate == null || endDate.equals(""))
				endDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 23:59:59";
		}
		//统计商品每个品种的销售信息
		List<Map> results = clubStatisticsDao.findSingleTypeClubCountByNewDate(startDate, endDate, name, state, area);
		if (area == null) {
			area = "all";
		}
		model.addAttribute("results", results);
		model.addAttribute("size", results.size());
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("name", name);
		model.addAttribute("state", state);
		model.addAttribute("area", area);
		model.addAttribute("date", new Date());
		Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
		page.setCount(results.size());
		page.initialize();//重新计算页码信息
		model.addAttribute("page", page);
		return "oa/statistics/org/singleTypeClubStatistics";
	}

	@RequestMapping(value = "clubStatisticsList")
	public String clubStatisticsList(HttpServletRequest request, HttpServletResponse response, Model model) throws ParseException {
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String name = request.getParameter("name");
		String nowDate = request.getParameter("nowDate");
		String area = request.getParameter("area");
		if (area != null && area.equals("all")) {
			area = null;
		}
		if (nowDate == null) {
			nowDate = "";
		}
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if (!nowDate.equals("")) {
			if (nowDate.equals("year")) {
				startDate = String.valueOf(year) + "-01-01 00:00:00:";
				endDate = String.valueOf(year) + "-12-31 23:59:59";
			} else if (nowDate.equals("month")) {
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-01 00:00:00";
				endDate = String.valueOf(year) + "-" + String.valueOf(month + 1) + "-01 23:59:59";
			}
		} else {
			if (startDate == null || startDate.equals(""))
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 00:00:00";
			if (endDate == null || endDate.equals(""))
				endDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 23:59:59";
		}

		//统计商品每个品种的销售信息
		List<Map> results = clubStatisticsDao.myIncome(startDate, endDate, name, area);
		if (area == null) {
			area = "all";
		}
		if (!Collections3.isEmpty(results)) {
			model.addAttribute("results", results);
		}
		model.addAttribute("size", results.size());
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("name", name);
		model.addAttribute("area", area);
		model.addAttribute("date", new Date());
		Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
		//你这个功能根本不需要分页，我就不给你差总条数了，自己看着办吧。
		page.setCount(results.size());
		page.initialize();//重新计算页码信息
		model.addAttribute("page", page);
		return "oa/statistics/org/clubStatisticsList";
	}

	@RequestMapping(value = "clubStatisticsList/singleType")
	public String singleTypeClubStatisticsList(HttpServletRequest request, HttpServletResponse response, Model model) throws ParseException {
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String name = request.getParameter("name");
		String nowDate = request.getParameter("nowDate");
		String area = request.getParameter("area");
		if (area != null && area.equals("all")) {
			area = null;
		}
		if (nowDate == null) {
			nowDate = "";
		}
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if (!nowDate.equals("")) {
			if (nowDate.equals("year")) {
				startDate = String.valueOf(year) + "-01-01 00:00:00:";
				endDate = String.valueOf(year) + "-12-31 23:59:59";
			} else if (nowDate.equals("month")) {
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-01 00:00:00";
				endDate = String.valueOf(year) + "-" + String.valueOf(month + 1) + "-01 23:59:59";
			}
		} else {
			if (startDate == null || startDate.equals(""))
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 00:00:00";
			if (endDate == null || endDate.equals(""))
				endDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 23:59:59";
		}

		//统计商品每个品种的销售信息
		List<Map> results = clubStatisticsDao.myIncomeSingleType(startDate, endDate, name, area);
		if (area == null) {
			area = "all";
		}
		if (!Collections3.isEmpty(results)) {
			model.addAttribute("results", results);
		}
		model.addAttribute("size", results.size());
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("name", name);
		model.addAttribute("area", area);
		model.addAttribute("date", new Date());
		Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
		//你这个功能根本不需要分页，我就不给你差总条数了，自己看着办吧。
		page.setCount(results.size());
		page.initialize();//重新计算页码信息
		model.addAttribute("page", page);
		return "oa/statistics/org/singleTypeClubStatisticsList";
	}
}
