package com.cku.oa.statistics.strategy;




import com.thinkgem.jeesite.common.utils.DateUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class YearToMonthSplitUtils {
    //系统录入正常拆分
    public static List<YearToMonthSplitEntity> splitYearToMonth(Date beginDate,int step, BigDecimal payTotal, BigDecimal payPrice){
        List<YearToMonthSplitEntity> list = new ArrayList<>(12);
        BigDecimal moneyPerMonth = new BigDecimal(0);
        BigDecimal moneyLastMonth = new BigDecimal(0);
        BigDecimal pricePerMonth = new BigDecimal(0);
        BigDecimal priceLastMonth = new BigDecimal(0);
        //实缴金额为0的不处理

        moneyPerMonth = payTotal.divide(new BigDecimal(step),2,BigDecimal.ROUND_HALF_UP);
        moneyLastMonth = payTotal.subtract(new BigDecimal(step-1).multiply(moneyPerMonth));

        pricePerMonth = payPrice.divide(new BigDecimal(step),2,BigDecimal.ROUND_HALF_UP);
        priceLastMonth = payPrice.subtract(new BigDecimal(step-1).multiply(pricePerMonth));


        Date paymentDate = (Date) beginDate.clone();
        beginDate.setHours(23);
        beginDate.setMinutes(0);
        beginDate.setSeconds(0);
        Calendar ca = Calendar.getInstance();
        ca.setTime(beginDate);

        //计算分期的起始时间
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(beginDate);
        tempCal.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date installmentBeginDate = tempCal.getTime();

        tempCal.add(tempCal.MONTH, step-1);
        Date installmentEndDate = tempCal.getTime();


        //存入12个月中
        for(int i=0;i<step;i++){
            YearToMonthSplitEntity ytm = new YearToMonthSplitEntity();
            ytm.setInstallmentBeginDate(installmentBeginDate);
            ytm.setInstallmentEndDate(installmentEndDate);
            if(i != 0){
                ca.add(ca.MONTH, 1);
            }
            ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
            ytm.setChargeDate(ca.getTime());
            if(i == (step-1)){
                ytm.setPaymentMoney(moneyLastMonth.toString());//实收
                ytm.setPrice(priceLastMonth.toString());//应收
            }else{
                ytm.setPaymentMoney(moneyPerMonth.toString());
                ytm.setPrice(pricePerMonth.toString());
            }

            list.add(ytm);
        }

        return list;
    }
    // 后台扣费录入了分摊区间情况 拆分
    /**
     *       A、	如扣款日期早于受益期间则扣款月至开始分摊月不摊销收入，自开始月开始摊销。
             B、	如扣款日期在受益区间内则开始月至扣款月的收入均分摊在扣款月，剩余金额在剩余区间内分摊。
             C、	如扣款日期晚于受益日期在扣款当月一次性确认收入。
     * @param beginDate
     * @param step
     * @param payTotal
     * @param payPrice
     * @return
     */
    public static List<YearToMonthSplitEntity> splitYearToMonthWithInstallment(Date beginDate,Date recordInstallmentStartDate,Date recordInstallmentEndDate, int step, BigDecimal payTotal, BigDecimal payPrice){
        List<YearToMonthSplitEntity> list = new ArrayList<>(12);
        BigDecimal moneyPerMonth = new BigDecimal(0);
        BigDecimal moneyLastMonth = new BigDecimal(0);
        BigDecimal pricePerMonth = new BigDecimal(0);
        BigDecimal priceLastMonth = new BigDecimal(0);
        //实缴金额为0的不处理
        moneyPerMonth = payTotal.divide(new BigDecimal(step),2,BigDecimal.ROUND_HALF_UP);
        moneyLastMonth = payTotal.subtract(new BigDecimal(step-1).multiply(moneyPerMonth));
        pricePerMonth = payPrice.divide(new BigDecimal(step),2,BigDecimal.ROUND_HALF_UP);
        priceLastMonth = payPrice.subtract(new BigDecimal(step-1).multiply(pricePerMonth));


        Date paymentDate = (Date) recordInstallmentStartDate.clone();
        recordInstallmentStartDate.setHours(23);
        recordInstallmentStartDate.setMinutes(0);
        recordInstallmentStartDate.setSeconds(0);
        Calendar ca = Calendar.getInstance();
        ca.setTime(recordInstallmentStartDate);

        //计算分期的起始时间
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(recordInstallmentStartDate);
        tempCal.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date installmentBeginDate = tempCal.getTime();

        tempCal.add(tempCal.MONTH, step-1);
        Date installmentEndDate = tempCal.getTime();

        if(beginDate.getTime()<recordInstallmentStartDate.getTime()){
            // A、	如扣款日期早于受益期间则扣款月至开始分摊月不摊销收入，自开始月开始摊销。
            //存入12个月中
            for(int i=0;i<step;i++){
                YearToMonthSplitEntity ytm = new YearToMonthSplitEntity();
                ytm.setInstallmentBeginDate(installmentBeginDate);
                ytm.setInstallmentEndDate(installmentEndDate);
                if(i != 0){
                    ca.add(ca.MONTH, 1);
                }
                ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
                ytm.setChargeDate(ca.getTime());
                if(i == (step-1)){
                    ytm.setPaymentMoney(moneyLastMonth.toString());//实收
                    ytm.setPrice(priceLastMonth.toString());//应收
                }else{
                    ytm.setPaymentMoney(moneyPerMonth.toString());
                    ytm.setPrice(pricePerMonth.toString());
                }
                list.add(ytm);
            }
        }else if(beginDate.getTime()>=recordInstallmentEndDate.getTime()){
            //C、	如扣款日期晚于受益日期在扣款当月一次性确认收入。
            YearToMonthSplitEntity ytm = new YearToMonthSplitEntity();
            ytm.setChargeDate(beginDate);
            ytm.setPaymentMoney(payTotal.toString());
            ytm.setPrice(payPrice.toString());
            list.add(ytm);
        }else{
            //B、	如扣款日期在受益区间内则开始月至扣款月的收入均分摊在扣款月，剩余金额在剩余区间内分摊。
            int cha = 0;
            try {
                cha = towDateMonth(beginDate,recordInstallmentStartDate);
            } catch (ParseException e) {
                e.printStackTrace();
            }

            if(step-cha==1){
                YearToMonthSplitEntity ytm = new YearToMonthSplitEntity();
                ca.add(ca.MONTH, cha);
                ytm.setChargeDate(ca.getTime());
                ytm.setInstallmentBeginDate(installmentBeginDate);
                ytm.setInstallmentEndDate(installmentEndDate);
                ytm.setPaymentMoney(payTotal.toString());
                ytm.setPrice(payPrice.toString());
                list.add(ytm);
            }else{
                for(int i=0;i<(step-cha);i++){
                    YearToMonthSplitEntity ytm = new YearToMonthSplitEntity();
                    ytm.setInstallmentBeginDate(installmentBeginDate);
                    ytm.setInstallmentEndDate(installmentEndDate);
                    if(i != 0){
                        ca.add(ca.MONTH, 1);
                    }else{
                        ca.add(ca.MONTH, cha);
                    }
                    ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
                    ytm.setChargeDate(ca.getTime());
                    if(i==0){
                        ytm.setPaymentMoney(moneyPerMonth.multiply(new BigDecimal(cha+1)).toString());
                        ytm.setPrice(pricePerMonth.multiply(new BigDecimal(cha+1)).toString());
                    }else if(i == (step-cha-1)){
                        ytm.setPaymentMoney(moneyLastMonth.toString());//实收
                        ytm.setPrice(priceLastMonth.toString());//应收
                    }else{
                        ytm.setPaymentMoney(moneyPerMonth.toString());
                        ytm.setPrice(pricePerMonth.toString());
                    }
                    list.add(ytm);
                }
            }

        }




        return list;
    }
    /**
     * 截止时间大于支付时间 return  截止时间
     * @param endDate
     * @param paymentDate
     * @return
     */
    public static Date getBeforeDate(Date endDate,Date paymentDate){
        long end = endDate.getTime();
        long pay = paymentDate.getTime();
        if(end-pay>0){
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();//日历对象
            calendar.setTime(endDate);
            calendar.add(Calendar.YEAR, -1);
            return calendar.getTime();
        }else{
            return paymentDate;
        }

    }

    /**
     * 两个时间的月份差
     * @param beginDate
     * @param endDate
     * @return
     * @throws ParseException
     */
    public static int towDateMonth(Date beginDate,Date endDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(sdf.parse(sdf.format(beginDate)));
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(sdf.parse(sdf.format(endDate)));
        int result = beginCalendar.get(Calendar.MONTH) - endCalendar.get(Calendar.MONTH);
        int month = (beginCalendar.get(Calendar.YEAR) - endCalendar.get(Calendar.YEAR)) * 12;
        return Math.abs(month + result);
    }
}
