/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import org.hibernate.validator.constraints.Length;


/**
 * OA-FCI秩序册代码对照表Entity
 * @author cuihuaiyu
 * @version 2018-02-27
 */
public class ShowFciContrast  {
	
	private static final long serialVersionUID = 1L;
	private String oaCode;		// OA年龄组代码
	private String oaAgeGroup;		// OA年龄组别
	private String proCode;		// 秩序册上场顺序代码
	private String proAgeGroup;		// 秩序册年龄组别
	private String proEn;		// 秩序册英文
	


	
	
	public void setOaCode(String oaCode) {
		this.oaCode = oaCode;
	}

	public void setProCode(String proCode) {
		this.proCode = proCode;
	}

	public String getOaCode() {
		return oaCode;
	}

	public String getProCode() {
		return proCode;
	}

	@Length(min=0, max=32, message="OA年龄组别长度必须介于 0 和 32 之间")
	public String getOaAgeGroup() {
		return oaAgeGroup;
	}

	public void setOaAgeGroup(String oaAgeGroup) {
		this.oaAgeGroup = oaAgeGroup;
	}

	@Length(min=0, max=32, message="秩序册年龄组别长度必须介于 0 和 32 之间")
	public String getProAgeGroup() {
		return proAgeGroup;
	}

	public void setProAgeGroup(String proAgeGroup) {
		this.proAgeGroup = proAgeGroup;
	}
	
	@Length(min=0, max=64, message="秩序册英文长度必须介于 0 和 64 之间")
	public String getProEn() {
		return proEn;
	}

	public void setProEn(String proEn) {
		this.proEn = proEn;
	}
	
}