/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.show.entity.ApplyDiscountListVo;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.show.entity.ShowApplyDiscount;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 报名满减优惠表DAO接口
 * @author xx
 * @version 2022-09-13
 */
@MyBatisDao
public interface ShowApplyDiscountDao extends CrudDao<ShowApplyDiscount> {
	
	/**
	 * 找到一个主赛事 一个犬主名下的最后一个周期
	 * @param showMainId
	 * @param discountSign
	 * @return
	 */
	String getLastCycleSign(@Param("showMainId") String showMainId,
			@Param("discountSign") String discountSign);
	/**
	 * 找到这个周期有多少个有效订单
	 * @param cycleSign
	 * @return
	 */
	Integer countByCycleSign(@Param("cycleSign") String cycleSign);
	
	/**
	 * 参与减免明细
	 */
	List<ApplyDiscountListVo> findApplyDiscountList(@Param("discountSign") String discountSign,
			@Param("showMainId") String showMainId);
	
	ShowApplyDiscount getByShowApplyId(@Param("showApplyId") String showApplyId);
	
	List<ShowApply> findInitializeList(@Param("mainShowId") String mainShowId);
	
	/**
	 * 找到这个周期有多少个有效免费订单
	 * @param cycleSign
	 * @return
	 */
	Integer countDiscountByCycleSign(@Param("cycleSign") String cycleSign);
	
}