/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.show.entity.ChildShows;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 赛事子表DAO接口
 * 
 * @author lgl
 * @version 2016-07-13
 */
@MyBatisDao
public interface ChildShowsDao extends CrudDao<ChildShows> {

	public List<String> findShowCodeList(String showRules);

	public ChildShows getByShowCode(String showCode);

	public List<String> getShowsNameOfBreed(String pedigreeCertified);

	public List<ChildShows> getByMainShowId(@Param("mainShowId") String mainShowId);

	public ChildShows getByShowCodeAndId(ChildShows childShows);

	Integer getMaxSerialNumber();

	int setSerialNumber(@Param("maxSerialNumber") Integer maxSerialNumber);

	Integer updateWinnerState(ChildShows childShows);

	List<ChildShows> find51List();
	

}