package com.cku.oa.shop.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.cku.oa.shop.entity.*;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.shop.dao.ShopCartsDao;
import com.cku.oa.shop.dao.ShopGoodsDao;
import com.cku.oa.shop.dao.ShopOrderDao;
import com.cku.oa.shop.dao.ShopOrderDetailDao;
import com.cku.oa.shop.dao.ShopUserAddressDao;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 商城订单Service
 * @author lyy
 * @version 2016-08-12
 */
@Service
@Transactional(readOnly = true)
public class ShopOrderService extends CrudService<ShopOrderDao, ShopOrder> {
	private static final String POST_ZHONGTIE = "zhongtie";
	private static final String POST_SUTONG = "sutong";
	private static final String POST_YUNDA = "yunda";
	@Autowired
	private ShopOrderDetailDao shopOrderDetailDao;
	@Autowired
	private ShopUserAddressDao shopUserAddressDao;
	@Autowired
	private ShopCartsDao shopCartsDao;
	@Autowired
	private ShopGoodsDao shopGoodsDao;
	@Autowired
	private ShopUserMoneyService shopUserMoneyService;
	@Autowired
	private PaymentRecordDao paymentRecordDao;
	@Autowired
	private MemberService memberService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private ShopUserAddressService shopUserAddressService;


	public ShopOrder get(String id) {
		ShopOrder result = super.get(id);
		if(result !=null){
			result.setOrderDetailList(shopOrderDetailDao.findListByOrderCode(result.getShopOrderCode()));
		}
		return result;
	}
	
	public List<ShopOrder> findList(ShopOrder shopOrder) {
		return super.findList(shopOrder);
	}
	
	public Page<ShopOrder> findPage(Page<ShopOrder> page, ShopOrder shopOrder) {
		shopOrder.setPage(page);
		List<ShopOrder> list = dao.findList(shopOrder);
		ShopOrderDetail shopOrderDetail = new ShopOrderDetail();
		for(ShopOrder item : list){
			item.setOrderDetailList(shopOrderDetailDao.findListByOrderCode(item.getShopOrderCode()));
		}
		page.setList(list);
		return page;
	}
	
	@Transactional(readOnly = false)
	public void save(ShopOrder shopOrder) {
		String runningNumber = SysCodeUtil.getPayRunningNumber();
		Date addTime = new Date();
		shopOrder.setIsSend("0");
		shopOrder.setIsReturn("0");
		shopOrder.setSendPostType(shopOrder.getPostType());
		shopOrder.setSendPostOrderNo(shopOrder.getPostOrderNo());
		shopOrder.setShopOrderCode(runningNumber);
		shopOrder.setState("0");
		shopOrder.setType("0");
		shopOrder.setOrderDate(addTime);
		shopOrder.setPaymentDate(addTime);
		shopOrder.setPaymentState("2");
		//是否新增临时地址临时地址
		if("0".equals(shopOrder.getIsNewAddress())){
			ShopUserAddress userAddress = shopUserAddressDao.get(new ShopUserAddress(shopOrder.getUserAddressId()));
			shopOrder.setProvince(userAddress.getProvince());
			shopOrder.setCity(userAddress.getCity());
			shopOrder.setAddress(userAddress.getAddress());
			shopOrder.setPostCode(userAddress.getPostCode());
			shopOrder.setPostDel(userAddress.getPostDel());
			shopOrder.setPostName(userAddress.getPostName());
		}else{
			shopOrder.setProvince(UserUtils.getAreaById(shopOrder.getProvince()).getName());
			shopOrder.setCity(UserUtils.getAreaById(shopOrder.getCity()).getName());
			shopOrder.setAddress(shopOrder.getAddress());
			//新增地址到商城用户地址表
			ShopUserAddress shopUserAddress = new ShopUserAddress();
			shopUserAddress.setMemberCode(shopOrder.getMemberCode());
			shopUserAddress.setProvince(shopOrder.getProvince());
			shopUserAddress.setCity(shopOrder.getCity());
			shopUserAddress.setAddress(shopOrder.getAddress());
			shopUserAddress.setPostCode(shopOrder.getPostCode());
			shopUserAddress.setPostDel(shopOrder.getPostDel());
			shopUserAddress.setPostName(shopOrder.getPostName());
			shopUserAddress.setIsDefault("0");
			shopUserAddressService.save(shopUserAddress);
		}


		BigDecimal postPrice = null;
		BigDecimal postPriceAdd = null;
		//查询邮费
		Area toArea = UserUtils.getAreaByName(shopOrder.getCity());
		if(POST_ZHONGTIE.equals(shopOrder.getPostType()) || POST_SUTONG.equals(shopOrder.getPostType())){
			postPrice = new BigDecimal(toArea.getSutong());
		}else if(POST_YUNDA.equals(shopOrder.getPostType())){
			postPrice = new BigDecimal(toArea.getYunda());
			postPriceAdd = new BigDecimal(toArea.getYundaAdd());
		}

		//订单的总数量，总价，总邮费
		BigDecimal orderNum= new BigDecimal("0");
		BigDecimal orderPrice= new BigDecimal("0");
		BigDecimal orderPostPrice= new BigDecimal("0");
		//循环内使用
		ShopGoods preShopGoods = null;
		BigDecimal bgoodsPrice = null;
		BigDecimal bgoodsNum = null;
		BigDecimal bgoodsWeight = null;
		BigDecimal orderDetailPrice = null;
		BigDecimal orderDetailPostPrice = null;
		//添加订单详细表，删除购物车表
		List<ShopOrderDetail> detailList = shopOrder.getOrderDetailList();
		for(ShopOrderDetail sod : detailList){
			sod.setShopOrderCode(runningNumber);
			sod.setAddDate(addTime);
			//计算邮费，总价
			preShopGoods = shopGoodsDao.get(new ShopGoods(sod.getGoodsId()));
			bgoodsPrice = new BigDecimal(sod.getGoodsPrice());
			bgoodsNum = new BigDecimal(sod.getGoodsNum());
			bgoodsWeight = new BigDecimal(preShopGoods.getWeight());
			orderDetailPrice = null;
			orderDetailPostPrice = null;
			//购物车的商品是否是买赠
			sod.getIsBuyGifts();
			//商品属性，买赠
			//preShopGoods.getBuyGifts();
			//商品属性，邮费
			//preShopGoods.getIsFreight();
			//商品属性，返利
			//preShopGoods.getIsRebate();
			//商品属性，限购
			//preShopGoods.getLimits();


			if(postPrice==null && postPriceAdd==null){
				if("0".equals(preShopGoods.getIsFreight())){
					orderDetailPostPrice = new BigDecimal("0");
				}else{
					orderDetailPostPrice = new BigDecimal("0");
				}
				if("1".equals(sod.getIsBuyGifts())){
					orderDetailPrice = new BigDecimal("0");
				}else{
					orderDetailPrice = bgoodsPrice.multiply(bgoodsNum);
				}

			}else if(postPrice !=null && postPriceAdd==null){
				if("0".equals(preShopGoods.getIsFreight())){
					orderDetailPostPrice = new BigDecimal("0");
				}else{
					orderDetailPostPrice = bgoodsWeight.multiply(bgoodsNum).multiply(postPrice);
				}
				if("1".equals(sod.getIsBuyGifts())){
					orderDetailPrice = new BigDecimal("0").add(orderDetailPostPrice);
				}else{
					orderDetailPrice = bgoodsPrice.multiply(bgoodsNum).add(orderDetailPostPrice);
				}
			}else if(postPrice!=null && postPriceAdd!=null){
				if("0".equals(preShopGoods.getIsFreight())){
					orderDetailPostPrice = new BigDecimal("0");
				}else{
					//总重量
					BigDecimal bCWeight =  bgoodsNum.multiply(bgoodsWeight);
					if(bCWeight.compareTo(new BigDecimal("1"))>=0){
						BigDecimal firstPostPrice = new BigDecimal("1").multiply(postPrice);
						BigDecimal sendPostPrice = bCWeight.subtract(new BigDecimal("1")).multiply(postPriceAdd);
						orderDetailPostPrice = (firstPostPrice).add(sendPostPrice);
					}else{
						orderDetailPostPrice = bCWeight.multiply(postPrice);
					}
				}
				if("1".equals(sod.getIsBuyGifts())){
					orderDetailPrice = new BigDecimal("0").add(orderDetailPostPrice);
				}else{
					orderDetailPrice = bgoodsPrice.multiply(bgoodsNum).add(orderDetailPostPrice);
				}
			}
			sod.setPostPrice(orderDetailPostPrice.toString());
			sod.setTotalPrice(orderDetailPrice.toString());
			orderNum = orderNum.add(bgoodsNum);
			orderPrice = orderPrice.add(orderDetailPrice);
			orderPostPrice = orderPostPrice.add(orderDetailPostPrice);
			//删除购物车记录
			shopCartsDao.delete(new ShopCarts(sod.getId()));
			//修改商品销售数量
			shopGoodsDao.updateSaleNum(preShopGoods.getId(),(Integer.parseInt(preShopGoods.getSaleNum())+Integer.parseInt(sod.getGoodsNum()))+"");
			sod.preInsert();
			//添加订单详细表数据
			shopOrderDetailDao.insert(sod);
		}

		shopOrder.setNum(orderNum.toString());
		shopOrder.setPostPrice(orderPostPrice.toString());
		shopOrder.setPrice(orderPrice.toString());
		//余额支付，商城
		if("25".equals(shopOrder.getPaymentWay())){
			if("0".equals(shopOrder.getIsOrg())){
				memberService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice(),runningNumber);
			}else{
				shopUserMoneyService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice(),"");
			}
		};
		//26 返利支付
		if("26".equals(shopOrder.getPaymentWay())){
			shopUserMoneyService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice(),ShopUserMoneyService.REBATE);
		};
		super.save(shopOrder);
		//生成流水表
		PaymentRecord paymentRecord = new PaymentRecord();
		//paymentRecord.setOutTradeNo(shopMember.getOutTradeNo());
		paymentRecord.setMemberCode(shopOrder.getMemberCode());
		paymentRecord.setPrice(shopOrder.getPrice());
		paymentRecord.setPaymentRemarks(shopOrder.getMessage());
		paymentRecord.setPaymentWay(shopOrder.getPaymentWay());
		paymentRecord.setPaymentTime(shopOrder.getOrderDate());
		//商城余额支付
		paymentRecord.setChargingItemId("215");
		paymentRecord.setChargingItemNum(1);
		paymentRecord.setPaymentAmount(shopOrder.getPrice());
		paymentRecord.setPaymentState("2");
		paymentRecord.setRunningNumber(runningNumber);
		paymentRecord.preInsert();
		paymentRecordDao.insert(paymentRecord);
	}
	@Transactional(readOnly = false)
	public void clientSave(ShopOrder shopOrder) {
		Member member = UserUtils.getLoginMember();
		String runningNumber = SysCodeUtil.getPayRunningNumberWithMemberCode(member.getMemberCode());
		Date addTime = new Date();
		shopOrder.setIsSend("0");
		shopOrder.setIsReturn("0");
		//shopOrder.setSendPostType(shopOrder.getPostType());
//		shopOrder.setSendPostOrderNo(shopOrder.getPostOrderNo());
		shopOrder.setShopOrderCode(runningNumber);
		shopOrder.setState("0");
		shopOrder.setType("2");
		shopOrder.setOrderDate(addTime);
		shopOrder.setPaymentState("1");
		shopOrder.setAddress(shopOrder.getAddress());
		//是否新增临时地址临时地址
//		if("0".equals(shopOrder.getIsNewAddress())){
//			ShopUserAddress userAddress = shopUserAddressDao.get(new ShopUserAddress(shopOrder.getUserAddressId()));
//			shopOrder.setProvince(userAddress.getProvince());
//			shopOrder.setCity(userAddress.getCity());
//			shopOrder.setAddress(userAddress.getAddress());
//			shopOrder.setPostCode(userAddress.getPostCode());
//			shopOrder.setPostDel(userAddress.getPostDel());
//			shopOrder.setPostName(userAddress.getPostName());
//		}else{
//			shopOrder.setProvince(UserUtils.getAreaById(shopOrder.getProvince()).getName());
//			shopOrder.setCity(UserUtils.getAreaById(shopOrder.getCity()).getName());
//		}
		BigDecimal postPrice = null;
		BigDecimal postPriceAdd = null;
		//查询邮费
		Area toArea = UserUtils.getAreaByName(shopOrder.getCity());
		if(POST_ZHONGTIE.equals(shopOrder.getPostType()) || POST_SUTONG.equals(shopOrder.getPostType())){
			postPrice = new BigDecimal(toArea.getSutong());
		}else if(POST_YUNDA.equals(shopOrder.getPostType())){
			postPrice = new BigDecimal(toArea.getYunda());
			postPriceAdd = new BigDecimal(toArea.getYundaAdd());
		}
		
		//订单的总数量，总价，总邮费
		BigDecimal orderNum= new BigDecimal("0");
		BigDecimal orderPrice= new BigDecimal("0");
		BigDecimal orderPostPrice= new BigDecimal("0");
		//循环内使用
		ShopGoods preShopGoods = null;
		BigDecimal bgoodsPrice = null;
		BigDecimal bgoodsNum = null;
		BigDecimal bgoodsWeight = null;
		BigDecimal orderDetailPrice = null;
		BigDecimal orderDetailPostPrice = null;
		//添加订单详细表，删除购物车表
		List<ShopOrderDetail> detailList = shopOrder.getOrderDetailList();
		for(ShopOrderDetail sod : detailList){
			sod.setShopOrderCode(runningNumber);
			sod.setAddDate(addTime);
			//计算邮费，总价
			preShopGoods = shopGoodsDao.get(new ShopGoods(sod.getGoodsId()));
			Integer addNum = Integer.parseInt(sod.getGoodsNum());
			//分区计价
			if("1".equals(preShopGoods.getIsInterval())){
				if(preShopGoods.getInterval1Num().equals(preShopGoods.getInterval2Num())){
					if(addNum<Integer.parseInt(preShopGoods.getInterval1Num())){
						bgoodsPrice = new BigDecimal(preShopGoods.getInterval1Price());
					}else{
						bgoodsPrice = new BigDecimal(preShopGoods.getInterval2Price());
					}
				}else{
					if(addNum<Integer.parseInt(preShopGoods.getInterval1Num())){
						bgoodsPrice = new BigDecimal(preShopGoods.getInterval1Price());
					}else if(addNum<Integer.parseInt(preShopGoods.getInterval2Num())){
						bgoodsPrice = new BigDecimal(preShopGoods.getInterval2Price());
					}else{
						bgoodsPrice = new BigDecimal(preShopGoods.getInterval3Price());
					}
				}
			}else{
				bgoodsPrice = new BigDecimal(preShopGoods.getPrice());
			}
			bgoodsNum = new BigDecimal(sod.getGoodsNum());
			bgoodsWeight = new BigDecimal(preShopGoods.getWeight());
			orderDetailPrice = null;
			orderDetailPostPrice = null;
			//购物车的商品是否是买赠
			sod.getIsBuyGifts();
			//商品属性，买赠
			//preShopGoods.getBuyGifts();
			//商品属性，邮费
			//preShopGoods.getIsFreight();
			//商品属性，返利
			//preShopGoods.getIsRebate();
			//商品属性，限购
			//preShopGoods.getLimits();
			
			
			if(postPrice==null && postPriceAdd==null){
				if("0".equals(preShopGoods.getIsFreight())){
					orderDetailPostPrice = new BigDecimal("0");
				}else{
					orderDetailPostPrice = new BigDecimal("0");
				}
				if("1".equals(sod.getIsBuyGifts())){
					orderDetailPrice = new BigDecimal("0");
				}else{
					orderDetailPrice = bgoodsPrice.multiply(bgoodsNum);
				}
				
			}else if(postPrice !=null && postPriceAdd==null){
				if("0".equals(preShopGoods.getIsFreight())){
					orderDetailPostPrice = new BigDecimal("0");
				}else{
					orderDetailPostPrice = bgoodsWeight.multiply(bgoodsNum).multiply(postPrice);
				}
				if("1".equals(sod.getIsBuyGifts())){
					orderDetailPrice = new BigDecimal("0").add(orderDetailPostPrice);
				}else{
					orderDetailPrice = bgoodsPrice.multiply(bgoodsNum).add(orderDetailPostPrice);
				}
			}else if(postPrice!=null && postPriceAdd!=null){
				if("0".equals(preShopGoods.getIsFreight())){
					orderDetailPostPrice = new BigDecimal("0");
				}else{
					//总重量
					BigDecimal bCWeight =  bgoodsNum.multiply(bgoodsWeight);
					if(bCWeight.compareTo(new BigDecimal("1"))>=0){
						BigDecimal firstPostPrice = new BigDecimal("1").multiply(postPrice);
						BigDecimal sendPostPrice = bCWeight.subtract(new BigDecimal("1")).multiply(postPriceAdd);
						orderDetailPostPrice = (firstPostPrice).add(sendPostPrice);
					}else{
						orderDetailPostPrice = bCWeight.multiply(postPrice);
					}
				}
				if("1".equals(sod.getIsBuyGifts())){
					orderDetailPrice = new BigDecimal("0").add(orderDetailPostPrice);
				}else{
					orderDetailPrice = bgoodsPrice.multiply(bgoodsNum).add(orderDetailPostPrice);
				}
			}
			sod.setPostPrice(orderDetailPostPrice.toString());
			sod.setTotalPrice(orderDetailPrice.toString());
			orderNum = orderNum.add(bgoodsNum);
			orderPrice = orderPrice.add(orderDetailPrice);
			orderPostPrice = orderPostPrice.add(orderDetailPostPrice);

			if("1".equals(sod.getIsBuyGifts())){
				ShopCarts ownBuyShopCart = shopCartsDao.get(sod.getId());
				if(ownBuyShopCart.getGoodsNum().equals(sod.getGoodsNum())){
					//删除购物车记录
					shopCartsDao.delete(new ShopCarts(sod.getId()));
				}else{
					//修改购物车记录
					ownBuyShopCart.setGoodsNum(Integer.parseInt(ownBuyShopCart.getGoodsNum())-Integer.parseInt(sod.getGoodsNum())+"");
					shopCartsDao.update(ownBuyShopCart);
				}

			}else{
				//删除购物车记录
				shopCartsDao.delete(new ShopCarts(sod.getId()));
			}

			//修改商品销售数量
			shopGoodsDao.updateSaleNum(preShopGoods.getId(),(Integer.parseInt(preShopGoods.getSaleNum())+Integer.parseInt(sod.getGoodsNum()))+"");
			sod.preInsert();
			//添加订单详细表数据
			shopOrderDetailDao.insert(sod);
		}
		
		shopOrder.setNum(orderNum.toString());
		shopOrder.setPostPrice(orderPostPrice.toString());
		shopOrder.setPrice(orderPrice.toString());
//		//余额支付，商城
//		if("25".equals(shopOrder.getPaymentWay())){
//			if("0".equals(shopOrder.getIsOrg())){
//				memberService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice());
//			}else{
//				shopUserMoneyService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice(),null);
//			}
//		};
//		//26 返利支付
//		if("26".equals(shopOrder.getPaymentWay())){
//			shopUserMoneyService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice(),ShopUserMoneyService.REBATE);
//		};
		super.save(shopOrder);
//		//生成流水表
//		PaymentRecord paymentRecord = new PaymentRecord();
//		//paymentRecord.setOutTradeNo(shopMember.getOutTradeNo());
//		paymentRecord.setMemberCode(shopOrder.getMemberCode());
//		paymentRecord.setPrice(shopOrder.getPrice());
//		paymentRecord.setPaymentRemarks(shopOrder.getMessage());
//		paymentRecord.setPaymentWay(shopOrder.getPaymentWay());
//		paymentRecord.setPaymentTime(shopOrder.getOrderDate());
//		//商城余额支付
//		paymentRecord.setChargingItemId("215");
//		paymentRecord.setChargingItemNum(1);
//		paymentRecord.setPaymentAmount(shopOrder.getPrice());
//		paymentRecord.setPaymentState("2");
//		paymentRecord.setRunningNumber(runningNumber);
//		paymentRecord.preInsert();
//		paymentRecordDao.insert(paymentRecord);
	}
	
	@Transactional(readOnly = false)
	public void clientBalPay(ShopOrder shopOrder){
		clientPay(shopOrder);
		memberService.memberCharge(UserUtils.getLoginMember().getMemberCode(), shopOrder.getPrice(),shopOrder.getShopOrderCode());
	}
	
	@Transactional(readOnly = false)
	public void clientPay(ShopOrder shopOrder) {
		Date now = new Date();
		//更新为已付款
		shopOrder.setPaymentState("2");
		shopOrder.setPaymentDate(now);
		super.save(shopOrder);
		//余额支付，商城
		if("25".equals(shopOrder.getPaymentWay())){
			if("0".equals(shopOrder.getIsOrg())){
				memberService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice(),shopOrder.getShopOrderCode());
			}else{
				shopUserMoneyService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice(),null);
			}
		};
		//26 返利支付
		if("26".equals(shopOrder.getPaymentWay())){
			shopUserMoneyService.memberCharge(shopOrder.getMemberCode(),shopOrder.getPrice(),ShopUserMoneyService.REBATE);
		};
		//生成流水表
		PaymentRecord paymentRecord = new PaymentRecord();
		//paymentRecord.setOutTradeNo(shopMember.getOutTradeNo());
		paymentRecord.setMemberCode(shopOrder.getMemberCode());
		paymentRecord.setPrice(shopOrder.getPrice());
		paymentRecord.setPaymentRemarks(shopOrder.getMessage());
		paymentRecord.setPaymentWay(shopOrder.getPaymentWay());
		paymentRecord.setPaymentTime(now);
		//商城余额支付
		paymentRecord.setChargingItemId("215");
		paymentRecord.setChargingItemNum(1);
		paymentRecord.setPaymentAmount(shopOrder.getPrice());
		paymentRecord.setPaymentState("2");
		paymentRecord.setRunningNumber(shopOrder.getShopOrderCode());
		paymentRecord.preInsert();
		User user = UserUtils.getLoginUser();
		paymentRecord.setCreateBy(user);
		paymentRecord.setUpdateBy(user);
		paymentRecordDao.insert(paymentRecord);
	}
	

	/**
	 * 查询邮费价格
	 * @param shopOrder
	 * @return
     */
	public String getPostPrice(ShopOrder shopOrder){
		BigDecimal postPrice = null;
		BigDecimal postPriceAdd = null;
		BigDecimal orderPostPrice = new BigDecimal("0");
		//是否新增临时地址临时地址
		if("0".equals(shopOrder.getIsNewAddress())){
			ShopUserAddress userAddress = shopUserAddressDao.get(new ShopUserAddress(shopOrder.getUserAddressId()));
			if (userAddress!=null) {
				shopOrder.setCity(userAddress.getCity());
			}
		}else{
			shopOrder.setCity(UserUtils.getAreaById(shopOrder.getCity()).getName());
		}

		//查询邮费
		Area toArea = UserUtils.getAreaByName(shopOrder.getCity());
		if("zhongtie".equals(shopOrder.getPostType()) || "sutong".equals(shopOrder.getPostType())){
			postPrice = new BigDecimal(toArea.getSutong());
		}else if("yunda".equals(shopOrder.getPostType())){
			postPrice = new BigDecimal(toArea.getYunda());
			postPriceAdd = new BigDecimal(toArea.getYundaAdd());
		}
		//循环内使用
		ShopGoods preShopGoods = null;
		BigDecimal bgoodsNum = null;
		BigDecimal bgoodsWeight = null;
		BigDecimal orderDetailPostPrice = null;
		//添加订单详细表，删除购物车表
		List<ShopCarts> detailList = shopCartsDao.findListByMemberCode(shopOrder.getMemberCode());
		for(ShopCarts sod : detailList){
			//计算邮费
			preShopGoods = shopGoodsDao.get(new ShopGoods(sod.getGoodsId()));
			bgoodsNum = new BigDecimal(sod.getGoodsNum());
			bgoodsWeight = new BigDecimal(preShopGoods.getWeight());
			orderDetailPostPrice = null;
			//如果是免邮费的商品
			if("0".equals(preShopGoods.getIsFreight())){
				orderDetailPostPrice = new BigDecimal("0");
			}else{
				if(postPrice==null && postPrice==null){
					orderDetailPostPrice = new BigDecimal("0");
				}else if(postPrice !=null && postPriceAdd==null){
					orderDetailPostPrice = bgoodsWeight.multiply(bgoodsNum).multiply(postPrice);
				}else if(postPrice!=null && postPriceAdd!=null){
					//总重量
					BigDecimal bCWeight =  bgoodsNum.multiply(bgoodsWeight);
					if(bCWeight.compareTo(new BigDecimal("1"))>=0){
						BigDecimal firstPostPrice = new BigDecimal("1").multiply(postPrice);
						BigDecimal sendPostPrice = bCWeight.subtract(new BigDecimal("1")).multiply(postPriceAdd);
						orderDetailPostPrice = (firstPostPrice).add(sendPostPrice);
					}else{
						orderDetailPostPrice = bCWeight.multiply(postPrice);
					}
				}
			}
			orderPostPrice = orderPostPrice.add(orderDetailPostPrice);
		}
		return orderPostPrice.toString();
	};

	public List<HashMap<String,String>> getLessGoodsList(String goodsId){
		ShopGoods shopGoods = shopGoodsDao.get(new ShopGoods(goodsId));
		List<HashMap<String,String>> result = new ArrayList<HashMap<String,String>>();
		List<ShopGoods> findList = shopGoodsDao.getLessGoodsList(shopGoods.getPrice());
		for (ShopGoods sg :findList) {
			HashMap<String,String> map = new HashMap<String,String>();
			map.put("id",sg.getId());
			map.put("name",sg.getName());
			result.add(map);
		}
		return result;
	}

	/**
	 * 撤销订单
	 * @param shopOrder
     */
	@Transactional(readOnly = false)
	public void delOrder(ShopOrder shopOrder) {
		shopOrder = get(shopOrder);
		if("1".equals(shopOrder.getIsSend())){
			throw new ZAException(-1,"订单已发货，不能删除！");
		}
		PaymentRecord delpaymentRecord = paymentRecordDao.getByRunningNumber(shopOrder.getShopOrderCode());
		//删除流水
		if(delpaymentRecord!=null){
			paymentRecordDao.delete(delpaymentRecord);
		}
		//退费------线下退费-修改为系统自动退回到账户

		//判断是不是合作机构
		Org org = orgService.getByMemberCode(shopOrder.getMemberCode());
		if(org==null){
			//非俱乐部会员 3，现金，25余额
			if("3".equals(shopOrder.getPaymentWay()) || "25".equals(shopOrder.getPaymentWay())){
				memberService.memberRecharge(shopOrder.getMemberCode(),shopOrder.getPrice(),new Date(),shopOrder.getShopOrderCode());
			}else{
				throw new ZAException(-1,"无法撤销订单，非俱乐部会员无此支付方式，不可撤销订单！");
			};
		}else{
			//俱乐部会员 3，现金，25余额，26返利
			if("3".equals(shopOrder.getPaymentWay()) || "25".equals(shopOrder.getPaymentWay())){
				shopUserMoneyService.memberRecharge(shopOrder.getMemberCode(),shopOrder.getPrice(),new Date(),"");
			}else if("26".equals(shopOrder.getPaymentWay())){
				shopUserMoneyService.memberRecharge(shopOrder.getMemberCode(),shopOrder.getPrice(),new Date(),ShopUserMoneyService.REBATE);
			}else{
				throw new ZAException(-1,"无法撤销订单，俱乐部会员无此支付方式,不可撤销订单！");
			};
		}
		//商品补回   删除订单详细
		List<ShopOrderDetail> detailList = shopOrderDetailDao.findListByOrderCode(shopOrder.getShopOrderCode());
		if(detailList!=null && detailList.size()>0){
			for(ShopOrderDetail detail : detailList){
				ShopGoods shopGoods = shopGoodsDao.get(new ShopGoods(detail.getGoodsId()));
				shopGoodsDao.updateSaleNum(detail.getGoodsId(),(Integer.parseInt(shopGoods.getSaleNum())-Integer.parseInt(detail.getGoodsNum()))+"");
				shopGoodsDao.updateNum(detail.getGoodsId(),(Integer.parseInt(shopGoods.getNum())+Integer.parseInt(detail.getGoodsNum()))+"");
				shopOrderDetailDao.delete(detail);
			}
		}
		//删除订单
			dao.delete(shopOrder);
	}

	/**
	 * 发货
	 * @param shopOrder
     */
	@Transactional(readOnly = false)
	public void sendOrder(ShopOrder shopOrder) {
		shopOrder.setIsSend("1");
		shopOrder.setSendDate(new Date());
		dao.updateSend(shopOrder);
	}

	/**
	 * 退货
	 * @param shopOrder
     */
	@Transactional(readOnly = false)
	public void returnGoods(ShopOrder shopOrder){
		List<ShopOrderDetail> list = shopOrder.getOrderDetailList();
		for(ShopOrderDetail shopOrderDetail : list){
			shopOrderDetailDao.updateReturn(shopOrderDetail);
		}
		shopOrder.setIsReturn("1");
		shopOrder.setReturnDate(new Date());
		dao.updateReturn(shopOrder);
	}
	
}