package com.cku.oa.sampling.entity;

import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 采样包流程日志Entity
 *
 * @author yuanshuai
 * @version 2023-05-22
 */
public class SamplingFlowLog extends DataEntity<SamplingFlowLog> {

	private static final long serialVersionUID = 1L;
	private String samplingCode;        // 采样包编号
	/**
	 * 流程类型（0添加，1下单，2邮寄，3绑定，4送检，5结果，6注销）
	 * 请使用com.cku.oa.sampling.enums.SamplingLogFlowTypeEnum
	 */
	private Integer flowType;        //
	private String operData;        // 操作信息(会员号，犬只编号，基因编码等)
	private String operBy;        // 创建者
	private String operName;        // 创建者名称
	private Date operTime;        // 创建时间

	public SamplingFlowLog() {

	}

	public SamplingFlowLog(String id) {
		super(id);
	}

	@Length(min = 1, max = 32, message = "采样包编号长度必须介于 1 和 32 之间")
	public String getSamplingCode() {
		return samplingCode;
	}

	public void setSamplingCode(String samplingCode) {
		this.samplingCode = samplingCode;
	}

	@NotNull(message = "流程类型（0添加，1下单，2邮寄，3绑定，4送检，5结果，6注销）不能为空")
	public Integer getFlowType() {
		return flowType;
	}

	public void setFlowType(Integer flowType) {
		this.flowType = flowType;
	}

	@Length(min = 0, max = 64, message = "操作信息(会员号，犬只编号，基因编码等)长度必须介于 0 和 64 之间")
	public String getOperData() {
		return operData;
	}

	public void setOperData(String operData) {
		this.operData = operData;
	}

	@Length(min = 1, max = 64, message = "创建者长度必须介于 1 和 64 之间")
	public String getOperBy() {
		return operBy;
	}

	public void setOperBy(String operBy) {
		this.operBy = operBy;
	}

	public String getOperName() {
		return operName;
	}

	public void setOperName(String operName) {
		this.operName = operName;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message = "创建时间不能为空")
	public Date getOperTime() {
		return operTime;
	}

	public void setOperTime(Date operTime) {
		this.operTime = operTime;
	}

}