package com.cku.oa.sampling.dao;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.sampling.entity.Sampling;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 采样包DAO接口
 *
 * @author yuanshuai
 * @version 2023-05-22
 */
@MyBatisDao
public interface SamplingDao extends CrudDao<Sampling> {

	/**
	 * 根据采样包编号查询
	 *
	 * @author yuanshuai
	 * @date 2023/5/24 16:36
	 */
	Sampling findBySamplingCode(@Param("samplingCode") String samplingCode);

	/**
	 * 根据采样包编号查询-区分大小写
	 *
	 * @author yuanshuai
	 * @date 2023/8/7 17:09
	 */
	Sampling findBySamplingCodeWithCase(@Param("samplingCode") String samplingCode);

	/**
	 * 根据采样包编号查询数量
	 *
	 * @author yuanshuai
	 * @date 2023/5/23 10:56
	 */
	Integer findCountBySamplingCode(@Param("samplingCode") String samplingCode);

	/**
	 * 查找未使用过的采样包
	 *
	 * @author yuanshuai
	 * @date 2023/5/28 12:54
	 */
	List<Sampling> findUnuseList();

	/**
	 * 查找已绑定且没有dogId的采样包列表
	 *
	 * @author yuanshuai
	 * @date 2023/7/26 17:59
	 */
	List<Sampling> findBindNoDogIdList();

	/**
	 * 根据采样包IDlist查询采样包list
	 *
	 * @author yuanshuai
	 * @date 2023/5/24 11:00
	 */
	List<Sampling> findListByIdList(@Param("idList") List<String> idList);

	/**
	 * 根据会员号查采样包编号
	 *
	 * @author yuanshuai
	 * @date 2023/5/28 13:12
	 */
	List<Sampling> findListByMemberCode(@Param("memberCode") String memberCode);

	/**
	 * 根据采样包编号list查询采样包list
	 *
	 * @author yuanshuai
	 * @date 2023/5/23 10:56
	 */
	List<Sampling> findListBySamplingCodeList(@Param("samplingCodeList") List<String> samplingCodeList);

	/**
	 * 批量添加采样包
	 *
	 * @author yuanshuai
	 * @date 2023/5/23 11:07
	 */
	void batchInsert(@Param("samplingList") List<Sampling> samplingList);

	/**
	 * 更新邮寄信息
	 *
	 * @author yuanshuai
	 * @date 2023/5/25 14:22
	 */
	void updatePostInfo(Sampling sampling);

	/**
	 * 解绑会员信息
	 *
	 * @author yuanshuai * @date 2023/5/25 14:22
	 */
	void updateUnbindMemberInfo(Sampling sampling);

	/**
	 * 批量更新邮寄信息
	 *
	 * @author yuanshuai
	 * @date 2023/5/25 14:22
	 */
	void batchUpdatePostInfo(@Param("idList") List<String> idList,
							 @Param("distributionChannel") Integer distributionChannel, @Param("memberCode") String memberCode,
							 @Param("memberName") String memberName, @Param("updateBy") String updateBy,
							 @Param("updateDate") Date updateDate, @Param("remarks") String remarks);

	/**
	 * 批量解绑会员信息
	 *
	 * @author yuanshuai
	 * @date 2023/5/29 11:14
	 */
	void batchUpdateUnbindMemberInfo(@Param("idList") List<String> idList, @Param("updateBy") String updateBy,
									 @Param("updateDate") Date updateDate, @Param("remarks") String remarks);

	/**
	 * 更新绑定信息
	 *
	 * @author yuanshuai
	 * @date 2023/5/25 14:22
	 */
	void updateBindInfo(Sampling sampling);

	/**
	 * 更新绑定信息
	 *
	 * @author yuanshuai
	 * @date 2023/5/25 14:22
	 */
	void updateBindInfoMore(Sampling sampling);

	/**
	 * 解绑犬只信息
	 *
	 * @author yuanshuai * @date 2023/5/25 14:22
	 */
	void updateUnbindDogInfo(Sampling sampling);

	/**
	 * 更改采样包状态
	 *
	 * @author yuanshuai
	 * @date 2023/5/23 16:40
	 */
	void updateFlowState(Sampling sampling);

	/**
	 * 批量更改采样包状态
	 *
	 * @author yuanshuai
	 * @date 2023/5/23 16:40
	 */
	void batchUpdateFlowState(@Param("idList") List<String> idList, @Param("flowState") Integer flowState,
							  @Param("updateBy") String updateBy, @Param("updateDate") Date updateDate, @Param("remarks") String remarks);

	Sampling getByDogCode(@Param("dogCode") String dogCode, @Param("dogSourceType") Integer dogSourceType);

	List<Sampling> findBindRecordByDogCodes(@Param("dogCodes") List<String> dogCodes);

	/**
	 * 更新送检信息
	 *
	 * @author yuanshuai
	 * @date 2023/6/26 10:40
	 */
	void updateSend(Sampling sampling);

	/**
	 * 批量更新送检信息
	 *
	 * @author yuanshuai
	 * @date 2023/6/26 10:44
	 */
	void batchUpdateSend(@Param("idList") List<String> idList, @Param("flowState") Integer flowState,
						 @Param("updateBy") String updateBy, @Param("updateDate") Date updateDate);

	/**
	 * 更新犬只ID
	 *
	 * @author yuanshuai
	 * @date 2023/7/27 10:09
	 */
	void updateDogId(@Param("id") String id, @Param("dogId") String dogId);


	/**
	 * 更新犬只信息
	 *
	 * @author yuanshuai
	 * @since 2024/3/29 10:39
	 */
	void updateDogInfo(Sampling sampling);

	/**
	 * 更新邮寄至上传结果全部信息
	 *
	 * @author yuanshuai
	 * @since 2024/3/29 10:39
	 */
	void updateRemarks(Sampling sampling);
}