/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.web;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.logUtil.JSONObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.handler.entity.HandlerShow;
import com.cku.oa.handler.service.HandlerShowService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 活动Controller
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/handlerShow")
public class HandlerShowController extends BaseController {

	@Autowired
	private HandlerShowService handlerShowService;

	@Autowired
	private GroomerShowRefereeService showRefereeService;

	@ModelAttribute
	public HandlerShow get(@RequestParam(required = false) String id) {
		HandlerShow entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = handlerShowService.get(id);
			entity.setShowName(StringEscapeUtils.unescapeHtml(entity.getShowName()));
		}
		if (entity == null) {
			entity = new HandlerShow();
		}
		return entity;
	}

	@RequiresPermissions("handler:handlerShow:view")
	@RequestMapping(value = { "list", "" })
	public String list(HandlerShow handlerShow, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<HandlerShow> page = handlerShowService.findPage(new Page<HandlerShow>(request, response), handlerShow);
		List<String> showAddressList = handlerShowService.getShowAddress();
		model.addAttribute("showAddressList", showAddressList);
		request.setAttribute("date", new Date());
		for (HandlerShow show : page.getList()) {
			if (show.getShowType().equals("10")) {
				Integer max = 0;
				Integer registerNum = 0;
				if (null != show.getMaxNumber()) {
					max = show.getMaxNumber();
				}
				if (null != show.getRegisterNumber()) {
					registerNum = show.getRegisterNumber();
				}
				show.setRegisterNumFlag(max > registerNum);
			} else {
				show.setRegisterNumFlag(true);
			}
			show.setShowName(StringEscapeUtils.unescapeHtml(show.getShowName()));
		}

		model.addAttribute("page", page);
		return "oa/handler/handlerShowList";
	}

	@RequiresPermissions("handler:handlerShow:add")
	@RequestMapping(value = "form")
	public String form(HandlerShow handlerShow, Model model) {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findHanlerReferee();
		model.addAttribute("showRefereeList", showRefereeList);
		model.addAttribute("handlerShow", handlerShow);
		return "oa/handler/handlerShowForm";
	}

	@RequiresPermissions("handler:handlerShow:edit")
	@RequestMapping(value = "edit")
	public String edit(HandlerShow handlerShow, Model model) {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findHanlerReferee();
		model.addAttribute("showRefereeList", showRefereeList);
		String[] levels = handlerShow.getTestLevel().split(",");
		handlerShow.setLevels(levels);
		model.addAttribute("handlerShow", handlerShow);
		return "oa/handler/handlerShowEdit";
	}

	/**
	 * 查看
	 * 
	 * @Author chaixueteng
	 * @2016年8月27日下午3:03:22
	 */
	@RequiresPermissions("handler:handlerShow:view")
	@RequestMapping(value = "view")
	public String view(HandlerShow handlerShow, Model model) {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findHanlerReferee();
		model.addAttribute("showRefereeList", showRefereeList);
		String[] levels = handlerShow.getTestLevel().split(",");
		handlerShow.setLevels(levels);
		model.addAttribute("handlerShow", handlerShow);
		return "oa/handler/handlerShowView";
	}

	@RequiresPermissions("handler:handlerShow:edit")
	@RequestMapping(value = "save")
	public String save(HandlerShow handlerShow, Model model, RedirectAttributes redirectAttributes) {
		try {
			logger.info("HandlerShowController.save param : {}", JSONObjectUtils.toJsonString(handlerShow));
			if ("10".equals(handlerShow.getShowType())||"11".equals(handlerShow.getShowType())) {
				handlerShow.setFee("0");
				handlerShow.setTestLevel(converLevel(handlerShow.getLevels()));
				handlerShow.setShowName(StringEscapeUtils.unescapeHtml(handlerShow.getShowName()));
			} else if ("12".equals(handlerShow.getShowType())||"13".equals(handlerShow.getShowType())) {
				handlerShow.setTestLevel(converLevel(handlerShow.getLevels()));
				handlerShow.setShowName(StringEscapeUtils.unescapeHtml(handlerShow.getShowName()));
			}
			handlerShowService.save(handlerShow);
		} catch (Exception e) {
			addMessage(redirectAttributes, "保存活动失败：" + "保存失败！");
			return "redirect:" + Global.getAdminPath() + "/handler/handlerShow/?repage";
		}
		addMessage(redirectAttributes, "保存活动成功");
		return "redirect:" + Global.getAdminPath() + "/handler/handlerShow/?repage";
	}

	@RequiresPermissions("handler:handlerShow:delete")
	@RequestMapping(value = "delete")
	public String delete(HandlerShow handlerShow, RedirectAttributes redirectAttributes) {
		handlerShowService.delete(handlerShow);
		addMessage(redirectAttributes, "删除活动成功");
		return "redirect:" + Global.getAdminPath() + "/handler/handlerShow/?repage";
	}

	/**
	 * 报名
	 * 
	 * @Author chaixueteng
	 * @2016年8月9日下午3:48:50
	 */
	@RequiresPermissions("handler:handlerShow:register")
	@RequestMapping(value = "registerForm")
	public String registerForm(HandlerShow handlerShow, HandlerRegister handlerRegister, Model model) {
		model.addAttribute("handlerRegister", handlerRegister);
		model.addAttribute("handlerShow", handlerShow);
		if ("9".equals(handlerShow.getShowType())) {
			return "oa/handler/handlerShowRegisterMatchForm";
		}

		if ("10".equals(handlerShow.getShowType())||"11".equals(handlerShow.getShowType())) {
			List<Dict> showLevels = DictUtils.getDictListValues("10".equals(handlerShow.getShowType())?"handler_test_level_examiner":"groomer_examiner_course_level",
					handlerShow.getTestLevel());
			handlerShow.setShowLevels(showLevels);
			return "oa/handler/handlerShowRegisterExaminerForm";
		}
		if ("12".equals(handlerShow.getShowType()) || "13".equals(handlerShow.getShowType())) {
			return "oa/handler/handlerShowRegisterTrainerForm";
		}
		return "oa/handler/handlerShowRegisterForm";
	}

	/**
	 * 重复赛事校验
	 * 
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "/codeCheck")
	@ResponseBody
	public String codeCheck(HttpServletRequest request, HttpServletResponse response) {
		String showCode = request.getParameter("showCode");
		String id = request.getParameter("id");
		String error = handlerShowService.codeCheck(showCode, id);
		return error;
	}

	private String converLevel(String[] arr) {
		String level = "";
		for (String str : arr) {
			level += str + ",";
		}
		return level.endsWith(",") ? level.substring(0, level.length() - 1) : level;
	}

}