/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.modules.sys.entity.Dict;

/**
 * 活动Entity
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
public class HandlerShow extends DataEntity<HandlerShow> {

	private static final long serialVersionUID = 1L;
	private String showCode; // 赛事编号
	private Date startTime; // 开始日期
	private Date endTime; // 结束日期
	private String showName; // 活动名称
	private String showAddress; // 活动地点
	private String registerState; // 活动报名状态(已废除)
	private String showType; // 活动类别
	private Date registerEndTime; // 截止时间
	private String topicLink; // 专题链接
	private String registerImage; // 报名图片
	private String reviewImage; // 回顾图片
	private String topicImage; // 专题图片
	private String referee; // 审查人
	private String hotelTel; // 酒店电话
	private String showIntroduce; // 活动介绍
	private String venueRoute; // 场馆路线
	private String accommodationIntroduce; // 住宿介绍
	private String timeTableLink; // 时间表链接
	private String rewardImageLink; // 赏励照链接
	private String championQualifactionLink; // 冠军登录链接
	private String creditsLink; // 积分链接
	private String discount; // 报名优惠
	private String fee; // 报名费
	private String testLevel; // 考试级别
	// private String testLevelExaminer; // 考试级别
	private String recommend;// 推荐活动（APP使用）
	private String venueId;// 场馆id
	private String hotelId;// 酒店id
	private Boolean filterType;// 过滤不显示的类型
	private String showPhoto;// 活动图片

	private String websitePhoto;
	private String photoRoute;

	private Integer maxNumber;
	private Integer registerNumber;
	private String[] levels;
	private List<Dict> showLevels;
	private String[] showGroup;
	private Boolean registerNumFlag;
	private Boolean showTypeOld;

	private List<String> showTypeList; // 活动类别
	
	private String isShowWebsite;//官网是否展示 0展示 1不展示

	private String showCodesText;
	
	public String getIsShowWebsite() {
		return isShowWebsite;
	}

	public void setIsShowWebsite(String isShowWebsite) {
		this.isShowWebsite = isShowWebsite;
	}


	public List<String> getShowTypeList() {
		return showTypeList;
	}

	public void setShowTypeList(List<String> showTypeList) {
		this.showTypeList = showTypeList;
	}

	public Boolean getShowTypeOld() {
		return showTypeOld;
	}

	public void setShowTypeOld(Boolean showTypeOld) {
		this.showTypeOld = showTypeOld;
	}

	public Boolean getRegisterNumFlag() {
		return registerNumFlag;
	}

	public void setRegisterNumFlag(Boolean registerNumFlag) {
		this.registerNumFlag = registerNumFlag;
	}

	public Boolean getFilterType() {
		return filterType;
	}

	public void setFilterType(Boolean filterType) {
		this.filterType = filterType;
	}

	private boolean oneYear; // 是否查询一年内

	private String showTypeExclude;

	public String getShowTypeExclude() {
		return showTypeExclude;
	}

	public void setShowTypeExclude(String showTypeExclude) {
		this.showTypeExclude = showTypeExclude;
	}

	public boolean isOneYear() {
		return oneYear;
	}

	public void setOneYear(boolean oneYear) {
		this.oneYear = oneYear;
	}

	private List<ChildShows> childShowsList = Lists.newArrayList();

	public List<ChildShows> getChildShowsList() {
		return childShowsList;
	}

	public void setChildShowsList(List<ChildShows> childShowsList) {
		this.childShowsList = childShowsList;
	}

	public HandlerShow() {
		super();
	}

	public HandlerShow(String id) {
		super(id);
	}

	@Length(min = 0, max = 100, message = "赛事编号长度必须介于 0 和 100 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	@Length(min = 0, max = 100, message = "活动名称长度必须介于 0 和 100 之间")
	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	@Length(min = 0, max = 100, message = "活动地点长度必须介于 0 和 100 之间")
	public String getShowAddress() {
		return showAddress;
	}

	public void setShowAddress(String showAddress) {
		this.showAddress = showAddress;
	}

	@Length(min = 0, max = 20, message = "活动报名状态长度必须介于 0 和 20 之间")
	public String getRegisterState() {
		return registerState;
	}

	public void setRegisterState(String registerState) {
		this.registerState = registerState;
	}

	@Length(min = 0, max = 64, message = "活动类别长度必须介于 0 和 64 之间")
	public String getShowType() {
		return showType;
	}

	public void setShowType(String showType) {
		this.showType = showType;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getRegisterEndTime() {
		return registerEndTime;
	}

	public void setRegisterEndTime(Date registerEndTime) {
		this.registerEndTime = registerEndTime;
	}

	@Length(min = 0, max = 255, message = "专题链接长度必须介于 0 和 255 之间")
	public String getTopicLink() {
		return topicLink;
	}

	public void setTopicLink(String topicLink) {
		this.topicLink = topicLink;
	}

	@Length(min = 0, max = 255, message = "报名图片长度必须介于 0 和 255 之间")
	public String getRegisterImage() {
		return registerImage;
	}

	public void setRegisterImage(String registerImage) {
		this.registerImage = registerImage;
	}

	@Length(min = 0, max = 255, message = "回顾图片长度必须介于 0 和 255 之间")
	public String getReviewImage() {
		return reviewImage;
	}

	public void setReviewImage(String reviewImage) {
		this.reviewImage = reviewImage;
	}

	@Length(min = 0, max = 255, message = "专题图片长度必须介于 0 和 255 之间")
	public String getTopicImage() {
		return topicImage;
	}

	public void setTopicImage(String topicImage) {
		this.topicImage = topicImage;
	}

	@Length(min = 0, max = 64, message = "审查人长度必须介于 0 和 64 之间")
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	@Length(min = 0, max = 64, message = "酒店电话长度必须介于 0 和 64 之间")
	public String getHotelTel() {
		return hotelTel;
	}

	public void setHotelTel(String hotelTel) {
		this.hotelTel = hotelTel;
	}

	public String getShowIntroduce() {
		return showIntroduce;
	}

	public void setShowIntroduce(String showIntroduce) {
		this.showIntroduce = showIntroduce;
	}

	public String getVenueRoute() {
		return venueRoute;
	}

	public void setVenueRoute(String venueRoute) {
		this.venueRoute = venueRoute;
	}

	public String getAccommodationIntroduce() {
		return accommodationIntroduce;
	}

	public void setAccommodationIntroduce(String accommodationIntroduce) {
		this.accommodationIntroduce = accommodationIntroduce;
	}

	@Length(min = 0, max = 255, message = "时间表链接长度必须介于 0 和 255 之间")
	public String getTimeTableLink() {
		return timeTableLink;
	}

	public void setTimeTableLink(String timeTableLink) {
		this.timeTableLink = timeTableLink;
	}

	@Length(min = 0, max = 255, message = "赏励照链接长度必须介于 0 和 255 之间")
	public String getRewardImageLink() {
		return rewardImageLink;
	}

	public void setRewardImageLink(String rewardImageLink) {
		this.rewardImageLink = rewardImageLink;
	}

	@Length(min = 0, max = 255, message = "冠军登录链接长度必须介于 0 和 255 之间")
	public String getChampionQualifactionLink() {
		return championQualifactionLink;
	}

	public void setChampionQualifactionLink(String championQualifactionLink) {
		this.championQualifactionLink = championQualifactionLink;
	}

	@Length(min = 0, max = 500, message = "积分链接长度必须介于 0 和 500 之间")
	public String getCreditsLink() {
		return creditsLink;
	}

	public void setCreditsLink(String creditsLink) {
		this.creditsLink = creditsLink;
	}

	@Length(min = 0, max = 255, message = "报名优惠长度必须介于 0 和 255 之间")
	public String getDiscount() {
		return discount;
	}

	public void setDiscount(String discount) {
		this.discount = discount;
	}

	public String getFee() {
		return fee;
	}

	public void setFee(String fee) {
		this.fee = fee;
	}

	@Length(min = 0, max = 64, message = "考试级别长度必须介于 0 和 64 之间")
	public String getTestLevel() {
		return testLevel;
	}

	public void setTestLevel(String testLevel) {
		this.testLevel = testLevel;
	}

	public String getRecommend() {
		return recommend;
	}

	public void setRecommend(String recommend) {
		this.recommend = recommend;
	}

	public String getVenueId() {
		return venueId;
	}

	public String getHotelId() {
		return hotelId;
	}

	public void setVenueId(String venueId) {
		this.venueId = venueId;
	}

	public void setHotelId(String hotelId) {
		this.hotelId = hotelId;
	}

	public String getShowPhoto() {
		return showPhoto;
	}

	public void setShowPhoto(String showPhoto) {
		this.showPhoto = showPhoto;
	}

//	public String getTestLevelExaminer() {
//		return testLevelExaminer;
//	}
//
//	public void setTestLevelExaminer(String testLevelExaminer) {
//		this.testLevelExaminer = testLevelExaminer;
//	}

	public Integer getMaxNumber() {
		return maxNumber;
	}

	public void setMaxNumber(Integer maxNumber) {
		this.maxNumber = maxNumber;
	}

	public String[] getLevels() {
		return levels;
	}

	public void setLevels(String[] levels) {
		this.levels = levels;
	}

	public List<Dict> getShowLevels() {
		return showLevels;
	}

	public void setShowLevels(List<Dict> showLevels) {
		this.showLevels = showLevels;
	}

	public String[] getShowGroup() {
		return showGroup;
	}

	public void setShowGroup(String[] showGroup) {
		this.showGroup = showGroup;
	}

	public Integer getRegisterNumber() {
		return registerNumber;
	}

	public void setRegisterNumber(Integer registerNumber) {
		this.registerNumber = registerNumber;
	}

	public String getWebsitePhoto() {
		return websitePhoto;
	}

	public void setWebsitePhoto(String websitePhoto) {
		this.websitePhoto = websitePhoto;
	}

	public String getPhotoRoute() {
		return photoRoute;
	}

	public void setPhotoRoute(String photoRoute) {
		this.photoRoute = photoRoute;
	}

	public String getShowCodesText() {
		return showCodesText;
	}

	public void setShowCodesText(String showCodesText) {
		this.showCodesText = showCodesText;
	}
}