/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 报名Entity
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
public class HandlerRegister extends DataEntity<HandlerRegister> {

	private static final long serialVersionUID = 1L;
	@ExcelField(title = "id", align = 2, sort = 1)
	private String id;
	@ExcelField(title = "报名序号", align = 2, sort = 16)
	private String registerCode; // 报名序号
	@ExcelField(title = "会员号", align = 2, sort = 2)
	private String memberCode; // 会员号
	private String source; // 来源
	@ExcelField(title = "姓名", align = 2, sort = 3)
	private String name; // 姓名
	@ExcelField(title = "性别", align = 2, sort = 4)
	private String gender; // 性别
	@ExcelField(title = "移动电话", align = 2, sort = 5)
	private String mobile; // 电话
	@ExcelField(title = "参赛级别", align = 2, sort = 13)
	private String showLevel; // 参赛级别
	@ExcelField(title = "培训机构", align = 2, sort = 7)
	private String schoolNameCn; // 培训学校
	@ExcelField(title = "报名费", align = 2, sort = 17)
	private String fee; // 报名费
	@ExcelField(title = "请假及取消", align = 2, sort = 18)
	private String leaveCancel; // 请假及取消
	private String showLeave; // 赛场请假
	private String showDogBreed; // 比赛犬种(数据库已废除)
	private String orderPrice; // 单价
	private String paymentMemberCode; // 付款会员号
	private String reviewer; // 操作人员
	@ExcelField(title = "成绩", align = 2, sort = 21)
	private String grade; // 成绩
	@ExcelField(title = "审查员", align = 2, sort = 19)
	private String referee; // 审查人
	private String paymentItemId; // 收费项目
	@ExcelField(title = "桌面审查犬", align = 2, sort = 8)
	private String desktopReviewerDog; // 桌面审查犬
	@ExcelField(title = "地面审查犬", align = 2, sort = 9)
	private String floorReviewerDog; // 地面审查犬
	@ExcelField(title = "任意品种", align = 2, sort = 10)
	private String anyBreed; // 任意品种
	@ExcelField(title = "美容品种", align = 2, sort = 11)
	private String groomerBreed; // 美容品种
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	@ExcelField(title = "缴费状态", align = 2, sort = 6)
	private String paymentState; // 付款的状态
	private Date paymentTime; // 付款时间
	private String proccessState; // 流程状态
	private Date proccessTime; // 流程变更的时间
	@ExcelField(title = "running_number", align = 2, sort = 14)
	private String runningNumber; // 流水号
	private String reviewRemarks; // 审核的意见
	private String avatar; // 照片
	@ExcelField(title = "赛事编号", align = 2, sort = 12)
	private String showCode; // 赛事编号
	private Date gradeTime; // 录入成绩时间
	@ExcelField(title = "序号", align = 2, sort = 20)
	private String testNo; // 考试号
	@ExcelField(title = "参加考试日期", align = 2, sort = 22)
	private Date takeCertificateDate; // 参加考试日期
	@ExcelField(title = "del_tag", align = 2, sort = 15)
	private String delFlag; // 删除状态
	private String showDog; // 参赛犬只

	private HandlerShow handlerShow; // 活动

	private Member member;
	private String showGroup;

	private String[] showGroups;
	private String endFlag;

	/**
	 * 培训活动类型 0牵犬师 1训练师
	 */
	private String handlerShowType;

	private String reviewStateExclud; // 排除的审核状态

	public String[] getShowGroups() {
		return showGroups;
	}

	public void setShowGroups(String[] showGroups) {
		this.showGroups = showGroups;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public String getTestNo() {
		return testNo;
	}

	public void setTestNo(String testNo) {
		this.testNo = testNo;
	}

	public String getDelFlag() {
		return super.delFlag;
	}

	public void setDelFlag(String delFlag) {
		super.delFlag = delFlag;
	}

	public Date getTakeCertificateDate() {
		return takeCertificateDate;
	}

	public void setTakeCertificateDate(Date takeCertificateDate) {
		this.takeCertificateDate = takeCertificateDate;
	}

	public String getId() {
		return super.id;
	}

	public void setId(String id) {
		super.id = id;
	}

	public Date getGradeTime() {
		return gradeTime;
	}

	public void setGradeTime(Date gradeTime) {
		this.gradeTime = gradeTime;
	}

	public HandlerRegister() {
		super();
	}

	public HandlerRegister(String id) {
		super(id);
	}

	public String getRegisterCode() {
		return registerCode;
	}

	public void setRegisterCode(String registerCode) {
		this.registerCode = registerCode;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getShowLevel() {
		return showLevel;
	}

	public void setShowLevel(String showLevel) {
		this.showLevel = showLevel;
	}

	public String getSchoolNameCn() {
		return schoolNameCn;
	}

	public void setSchoolNameCn(String schoolNameCn) {
		this.schoolNameCn = schoolNameCn;
	}

	public String getFee() {
		return fee;
	}

	public void setFee(String fee) {
		this.fee = fee;
	}

	@Length(min = 0, max = 1, message = "请假及取消长度必须介于 0 和 1 之间")
	public String getLeaveCancel() {
		return leaveCancel;
	}

	public void setLeaveCancel(String leaveCancel) {
		this.leaveCancel = leaveCancel;
	}

	@Length(min = 0, max = 1, message = "赛场请假长度必须介于 0 和 1 之间")
	public String getShowLeave() {
		return showLeave;
	}

	public void setShowLeave(String showLeave) {
		this.showLeave = showLeave;
	}

	@Length(min = 0, max = 64, message = "比赛犬种长度必须介于 0 和 64 之间")
	public String getShowDogBreed() {
		return showDogBreed;
	}

	public void setShowDogBreed(String showDogBreed) {
		this.showDogBreed = showDogBreed;
	}

	public String getOrderPrice() {
		return orderPrice;
	}

	public void setOrderPrice(String orderPrice) {
		this.orderPrice = orderPrice;
	}

	@Length(min = 0, max = 64, message = "付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 0, max = 100, message = "操作人员长度必须介于 0 和 100 之间")
	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}

	@Length(min = 0, max = 10, message = "成绩长度必须介于 0 和 10 之间")
	public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	@Length(min = 0, max = 64, message = "审查人长度必须介于 0 和 64 之间")
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	@Length(min = 0, max = 150, message = "收费项目长度必须介于 0 和 150 之间")
	public String getPaymentItemId() {
		return paymentItemId;
	}

	public void setPaymentItemId(String paymentItemId) {
		this.paymentItemId = paymentItemId;
	}

	@Length(min = 0, max = 100, message = "桌面审查犬长度必须介于 0 和 100 之间")
	public String getDesktopReviewerDog() {
		return desktopReviewerDog;
	}

	public void setDesktopReviewerDog(String desktopReviewerDog) {
		this.desktopReviewerDog = desktopReviewerDog;
	}

	@Length(min = 0, max = 100, message = "地面审查犬长度必须介于 0 和 100 之间")
	public String getFloorReviewerDog() {
		return floorReviewerDog;
	}

	public void setFloorReviewerDog(String floorReviewerDog) {
		this.floorReviewerDog = floorReviewerDog;
	}

	@Length(min = 0, max = 100, message = "任意品种长度必须介于 0 和 100 之间")
	public String getAnyBreed() {
		return anyBreed;
	}

	public void setAnyBreed(String anyBreed) {
		this.anyBreed = anyBreed;
	}

	@Length(min = 0, max = 100, message = "美容品种长度必须介于 0 和 100 之间")
	public String getGroomerBreed() {
		return groomerBreed;
	}

	public void setGroomerBreed(String groomerBreed) {
		this.groomerBreed = groomerBreed;
	}

	@Length(min = 0, max = 20, message = "审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 0, max = 20, message = "付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@Length(min = 0, max = 20, message = "流程状态长度必须介于 0 和 20 之间")
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}

	@Length(min = 0, max = 100, message = "流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 255, message = "审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min = 0, max = 200, message = "照片长度必须介于 0 和 200 之间")
	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	public HandlerShow getHandlerShow() {
		return handlerShow;
	}

	public void setHandlerShow(HandlerShow handlerShow) {
		this.handlerShow = handlerShow;
	}

	public String getShowDog() {
		return showDog;
	}

	public void setShowDog(String showDog) {
		this.showDog = showDog;
	}

	public String getShowGroup() {
		return showGroup;
	}

	public void setShowGroup(String showGroup) {
		this.showGroup = showGroup;
	}

	public String getEndFlag() {
		return endFlag;
	}

	public void setEndFlag(String endFlag) {
		this.endFlag = endFlag;
	}

	public String getHandlerShowType() {
		return handlerShowType;
	}

	public void setHandlerShowType(String handlerShowType) {
		this.handlerShowType = handlerShowType;
	}

	public String getReviewStateExclud() {
		return reviewStateExclud;
	}

	public void setReviewStateExclud(String reviewStateExclud) {
		this.reviewStateExclud = reviewStateExclud;
	}
}