/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.entity;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 资格证书Entity
 * @author 柴雪腾
 * @version 2016-08-08
 */
public class HandlerQualificationCertificate extends DataEntity<HandlerQualificationCertificate> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title="id", align=2, sort=1)
	private String id;   //id
	@ExcelField(title="会员号", align=2, sort=7)
	private String memberCode;		// 会员号
	@ExcelField(title="姓名", align=2, sort=2)
	private String name;  //导出专用   
	@ExcelField(title="性别", align=2, sort=3)
	private String gender;		// 导出专用性别
	private String registerId; //报名表id
	@ExcelField(title="取证日期", align=2, sort=4)
	private Date takeCertificateDate;		// 取证日期
	@ExcelField(title="证书号", align=2, sort=6)
	private String certificateCode;		// 证书编号
	@ExcelField(title="级别", align=2, sort=5)
	private String certificateLevelCn;		// 证书级别-cn
	private String certificateLevelEn;		// 证书级别-en
	private Date issueDate;		// 签发日期
	private String handlerRegisterId;		// 报名表id
	private String reviewer;		// 审查员
	private String printState;		// 打印状态
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private String proccessState;		// 流程状态
	private Date proccessTime;		// 流程变更的时间
	private String runningNumber;		// 流水号
	private String reviewRemarks;		// 审核的意见
	private HandlerRegister handlerRegister; //报名表
	private Member member;

	private String taskDate;
	private String issDate;
	private String schoolNameCn;
	private List<String> level;

	private String avatarBase64;
	
	private String endFlag;

	private String certificateType;

	public String getTaskDate() {
		return taskDate;
	}

	public void setTaskDate(String taskDate) {
		this.taskDate = taskDate;
	}

	public String getIssDate() {
		return issDate;
	}

	public void setIssDate(String issDate) {
		this.issDate = issDate;
	}

	public HandlerQualificationCertificate() {
		super();
	}

	public HandlerQualificationCertificate(String id){
		super(id);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	@Length(min=0, max=100, message="会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getTakeCertificateDate() {
		return takeCertificateDate;
	}

	public void setTakeCertificateDate(Date takeCertificateDate) {
		this.takeCertificateDate = takeCertificateDate;
	}
	
	@Length(min=0, max=64, message="证书编号长度必须介于 0 和 64 之间")
	public String getCertificateCode() {
		return certificateCode;
	}



	public String getRegisterId() {
		return registerId;
	}

	public void setRegisterId(String registerId) {
		this.registerId = registerId;
	}

	public String getCertificateLevelCn() {
		return certificateLevelCn;
	}

	public void setCertificateLevelCn(String certificateLevelCn) {
		this.certificateLevelCn = certificateLevelCn;
	}

	public String getCertificateLevelEn() {
		return certificateLevelEn;
	}

	public void setCertificateLevelEn(String certificateLevelEn) {
		this.certificateLevelEn = certificateLevelEn;
	}

	public void setCertificateCode(String certificateCode) {
		this.certificateCode = certificateCode;
	}


	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}
	
	
	
	public String getHandlerRegisterId() {
		return handlerRegisterId;
	}

	public void setHandlerRegisterId(String handlerRegisterId) {
		this.handlerRegisterId = handlerRegisterId;
	}

	public HandlerRegister getHandlerRegister() {
		return handlerRegister;
	}

	public void setHandlerRegister(HandlerRegister handlerRegister) {
		this.handlerRegister = handlerRegister;
	}

	@Length(min=0, max=100, message="审查员长度必须介于 0 和 100 之间")
	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}
	
	@Length(min=0, max=20, message="打印状态长度必须介于 0 和 20 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}
	
	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}
	
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}

	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}

	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public List<String> getLevel() {
		return level;
	}

	public void setLevel(List<String> level) {
		this.level = level;
	}

	public String getSchoolNameCn() {
		return schoolNameCn;
	}

	public void setSchoolNameCn(String schoolNameCn) {
		this.schoolNameCn = schoolNameCn;
	}

	public String getAvatarBase64() {
		return avatarBase64;
	}

	public void setAvatarBase64(String avatarBase64) {
		this.avatarBase64 = avatarBase64;
	}

	public String getEndFlag() {
		return endFlag;
	}

	public void setEndFlag(String endFlag) {
		this.endFlag = endFlag;
	}

	public String getCertificateType() {
		return certificateType;
	}

	public void setCertificateType(String certificateType) {
		this.certificateType = certificateType;
	}
}