package com.cku.oa.groomer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.groomer.entity.GroomerShowBreeds;
import com.cku.oa.groomer.service.GroomerShowBreedsService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 美容活动犬种Controller
 * 
 * @author Sunny
 * @version 2021-12-17
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerShowBreeds")
public class GroomerShowBreedsController extends BaseController {

	@Autowired
	private GroomerShowBreedsService groomerShowBreedsService;

	@ModelAttribute
	public GroomerShowBreeds get(@RequestParam(required = false) String id) {
		GroomerShowBreeds entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = groomerShowBreedsService.get(id);
		}
		if (entity == null) {
			entity = new GroomerShowBreeds();
		}
		return entity;
	}

	@RequiresPermissions("groomer:groomerShowBreeds:view")
	@RequestMapping(value = { "list", "" })
	public String list(GroomerShowBreeds groomerShowBreeds, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<GroomerShowBreeds> page = groomerShowBreedsService.findPage(new Page<GroomerShowBreeds>(request, response),
				groomerShowBreeds);
		model.addAttribute("page", page);
		return "oa/groomer/groomerShowBreedsList";
	}

	@RequiresPermissions("groomer:groomerShowBreeds:view")
	@RequestMapping(value = "form")
	public String form(GroomerShowBreeds groomerShowBreeds, Model model) {
		model.addAttribute("groomerShowBreeds", groomerShowBreeds);
		return "oa/groomer/groomerShowBreedsForm";
	}

	@RequiresPermissions("groomer:groomerShowBreeds:edit")
	@RequestMapping(value = "save")
	public String save(GroomerShowBreeds groomerShowBreeds, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerShowBreeds)) {
			return form(groomerShowBreeds, model);
		}
		groomerShowBreedsService.save(groomerShowBreeds);
		addMessage(redirectAttributes, "保存美容活动犬种成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerShowBreeds/?repage";
	}

	@RequiresPermissions("groomer:groomerShowBreeds:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerShowBreeds groomerShowBreeds, RedirectAttributes redirectAttributes) {
		groomerShowBreedsService.delete(groomerShowBreeds);
		addMessage(redirectAttributes, "删除美容活动犬种成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerShowBreeds/?repage";
	}

	@RequestMapping(value = "showBreeds")
	public String getGroomerShowBreeds(GroomerShowBreeds groomerShowBreeds, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		return groomerShowBreedsService.getGroomerShowBreeds(groomerShowBreeds,model);
	}


}