/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容资格认证笔试信息表Entity
 * @author hjx
 * @version 2023-11-23
 */
public class GroomerWrittenExamInfo extends DataEntity<GroomerWrittenExamInfo> {
	
	private static final long serialVersionUID = 1L;

	/**
	 * 赛事编号
	 */
	private String showCode;

	/**
	 * 报名序号
	 */
	private String registerId;

	/**
	 * 付款会员号
	 */
	private String paymentMemberCode;

	/**
	 * 会员code
	 */
	private String memberCode;

	/**
	 * 笔试成绩分数
	 */
	private String gradeWrite;

	/**
	 * 成绩录入时间
	 */
	private Date gradeTime;

	/**
	 * 开始考试日期
	 */
	private Date startExamTime;



	/**
	 * 考试完成时间
	 */
	private Date endExamTime;

	/**
	 * 考试用时
	 */
	private String examTime;

	/**
	 * 答题信息
	 */
	private String answerInfo;

	/**
	 * 当前试卷信息
	 */
	private String currentExamPaper;

	/**
	 * 提交考试状态 详见枚举
	 */
	private Integer commitExamType;

	/**
	 * 补考支付状态
	 */
	private String paymentState;

	/**
	 * 补考支付时间
	 */
	private Date paymentTime;

	/**
	 * 补考支付流水号
	 */
	private String runningNumber;

	/**
	 * 试卷Id
	 * @return
	 */
	private String examPaperId;

	/**
	 * 理论考试状态
	 * @return
	 */
	private Integer writtenExamStatus;

	/**
	 * 自动关单时间
	 * @return
	 */
	private Date autoCloseTime;

	/**
	 * 最后选中事件
	 * @return
	 */
	private Date lastSelectedTime;

	/**
	 * 订单编号
	 * @return
	 */
	private String orderCode;

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public Integer getWrittenExamStatus() {
		return writtenExamStatus;
	}

	public void setWrittenExamStatus(Integer writtenExamStatus) {
		this.writtenExamStatus = writtenExamStatus;
	}

	public String getExamPaperId() {
		return examPaperId;
	}

	public void setExamPaperId(String examPaperId) {
		this.examPaperId = examPaperId;
	}

	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	public GroomerWrittenExamInfo() {
		super();
	}

	public String getCurrentExamPaper() {
		return currentExamPaper;
	}

	public void setCurrentExamPaper(String currentExamPaper) {
		this.currentExamPaper = currentExamPaper;
	}

	public GroomerWrittenExamInfo(String id){
		super(id);
	}

	@Length(min=1, max=100, message="赛事编号长度必须介于 1 和 100 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	@Length(min=0, max=64, message="报名序号长度必须介于 0 和 64 之间")
	public String getRegisterId() {
		return registerId;
	}

	public void setRegisterId(String registerId) {
		this.registerId = registerId;
	}

	@Length(min=0, max=64, message="付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}
	
	@Length(min=0, max=255, message="操作人员长度必须介于 0 和 255 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=50, message="笔试成绩长度必须介于 0 和 50 之间")
	public String getGradeWrite() {
		return gradeWrite;
	}

	public void setGradeWrite(String gradeWrite) {
		this.gradeWrite = gradeWrite;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getGradeTime() {
		return gradeTime;
	}

	public void setGradeTime(Date gradeTime) {
		this.gradeTime = gradeTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartExamTime() {
		return startExamTime;
	}

	public void setStartExamTime(Date startExamTime) {
		this.startExamTime = startExamTime;
	}
	
	public String getExamTime() {
		return examTime;
	}

	public void setExamTime(String examTime) {
		this.examTime = examTime;
	}

	public String getAnswerInfo() {
		return answerInfo;
	}

	public void setAnswerInfo(String answerInfo) {
		this.answerInfo = answerInfo;
	}

	public Date getEndExamTime() {
		return endExamTime;
	}

	public void setEndExamTime(Date endExamTime) {
		this.endExamTime = endExamTime;
	}

	public Integer getCommitExamType() {
		return commitExamType;
	}

	public void setCommitExamType(Integer commitExamType) {
		this.commitExamType = commitExamType;
	}

	public Date getAutoCloseTime() {
		return autoCloseTime;
	}

	public void setAutoCloseTime(Date autoCloseTime) {
		this.autoCloseTime = autoCloseTime;
	}

	public Date getLastSelectedTime() {
		return lastSelectedTime;
	}

	public void setLastSelectedTime(Date lastSelectedTime) {
		this.lastSelectedTime = lastSelectedTime;
	}
}