/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.goods.dao;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.goods.entity.SysBusinessService;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 业务注册DAO接口
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
@MyBatisDao
public interface SysBusinessServiceDao extends CrudDao<SysBusinessService> {

	/**
	 * 根据业务分类ID查找list
	 *
	 * @author yuanshuai
	 * @date 2023/7/28 16:14
	 */
	List<SysBusinessService> findListByCate(@Param("cateId") String catId);
}