package com.cku.oa.finance.service;

import com.cku.oa.finance.dao.MemberBalanceDao;
import com.cku.oa.finance.entity.MemberAccount;
import com.cku.oa.finance.entity.MemberBalance;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/27
 * Time: 12:00
 */
@Service
@Transactional(readOnly = true)
public class MemberBalanceService extends CrudService<MemberBalanceDao, MemberBalance> {
    /**
     * 查询账户余额列表
     * @param page
     * @param memberBalance
     * @return
     */
    public Page<MemberBalance> getListByMemberCodePage(Page<MemberBalance> page, MemberBalance memberBalance){
        memberBalance.setPage(page);
        page.setList(dao.getListByMemberCodePage(memberBalance));
        return page;
    }
    public void export(MemberBalance memberBalance, HttpServletResponse response) throws IOException {
        List<MemberBalance> gqcList=dao.getListByMemberCodePage(memberBalance);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
       String execleName= formatter.format(memberBalance.getEndPaymentTime());
        new ExportExcel("", MemberBalance.class, 2)
                .setDataList(gqcList).write(response, "会员余额"+execleName+".xlsx").dispose();
    }
    public Page<MemberBalance> getListByMemberCodePageHistory(Page<MemberBalance> page, MemberBalance memberBalance){
        memberBalance.setPage(page);
        page.setList(dao.getListByMemberCodePageHistory(memberBalance));
        return page;
    }

    /**
     * 查询会员总余额
     * @return
     */
    public String totalMemberBalance(MemberBalance memberBalance){
      /*  if(null==memberBalance.getEndPaymentTime()){*/
            return dao.totalMemberBalance();
       /* }else{
            return  dao.totalMemberBalanceHistory(memberBalance);
        }*/

    }

    public List<MemberBalance> getListStatistics(MemberBalance memberBalance){
        List<MemberBalance> resultList = new ArrayList<MemberBalance>();
        //如果是空的话查询所有类型会员号
        //HZ,MRHZ,COMMON,T,S,C,Q
        if(StringUtils.isBlank(memberBalance.getMemberCode())){
            //All
            List<MemberBalance> listHZ = dao.getListStatisticsWithHZ(memberBalance);
            List<MemberBalance> listMRHZ = dao.getListStatisticsWithMRHZ(memberBalance);
            List<MemberBalance> listCommon = dao.getListStatisticsWithCommon(memberBalance);
            BigDecimal account = new BigDecimal(listCommon.get(0).getTotalPrice()).add(new BigDecimal(listHZ.get(0).getTotalPrice())).add(new BigDecimal(listMRHZ.get(0).getTotalPrice()));
            BigDecimal recharge = new BigDecimal(listCommon.get(1).getTotalPrice()).add(new BigDecimal(listHZ.get(1).getTotalPrice())).add(new BigDecimal(listMRHZ.get(1).getTotalPrice()));
            resultList.add(new MemberBalance(listCommon.get(0).getTotalType(),account.toString()));
            resultList.add(new MemberBalance(listCommon.get(1).getTotalType(),recharge.toString()));
        }else{
            String memberCode = memberBalance.getMemberCode();
            memberCode = memberCode.toUpperCase();
            if(memberCode.startsWith("HZ")){
                resultList = dao.getListStatisticsWithHZ(memberBalance);
            }else if(memberCode.startsWith("MRHZ")){
                resultList = dao.getListStatisticsWithMRHZ(memberBalance);
            }else{
                resultList = dao.getListStatisticsWithCommon(memberBalance);
            }
        }
        return resultList;
    }
}
