package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.service.DogChipChangeService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 芯片变更管理Controller
 * @author zhuoHeng
 * @version 2016-10-14
 */
@Controller
@RequestMapping(value = "${adminPath}/dogchipchangemanage/dogChipChange")
public class DogChipChangeController extends BaseController {

	@Autowired
	private DogChipChangeService dogChipChangeService;
	
	@ModelAttribute
	public DogChipChange get(@RequestParam(required=false) String id) {
		DogChipChange entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogChipChangeService.get(id);
		}
		if (entity == null){
			entity = new DogChipChange();
		}
		return entity;
	}
	
	@RequiresPermissions("dogchipchangemanage:dogChipChange:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogChipChange dogChipChange, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogChipChange> page = dogChipChangeService.findPage(new Page<DogChipChange>(request, response), dogChipChange); 
		model.addAttribute("page", page);
		return "oa/dog/dogchipchangemanage/dogChipChangeList";
	}

	@RequiresPermissions("dogchipchangemanage:dogChipChange:view")
	@RequestMapping(value = "form")
	public String form(DogChipChange dogChipChange, Model model) {
		model.addAttribute("dogChipChange", dogChipChange);
		return "oa/dog/dogchipchangemanage/dogChipChangeForm";
	}

	@RequiresPermissions("dogchipchangemanage:dogChipChange:edit")
	@RequestMapping(value = "save")
	public String save(DogChipChange dogChipChange, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogChipChange)){
			return form(dogChipChange, model);
		}
		dogChipChangeService.save(dogChipChange);
		addMessage(redirectAttributes, "保存芯片变更管理成功");
		return "redirect:"+Global.getAdminPath()+"/dogchipchangemanage/dogChipChange/?repage";
	}
	
	@RequiresPermissions("dogchipchangemanage:dogChipChange:edit")
	@RequestMapping(value = "delete")
	public String delete(DogChipChange dogChipChange, RedirectAttributes redirectAttributes) {
		dogChipChangeService.delete(dogChipChange);
		addMessage(redirectAttributes, "删除芯片变更管理成功");
		return "redirect:"+Global.getAdminPath()+"/dogchipchangemanage/dogChipChange/?repage";
	}

	/**
	 * 
	 * @Description：芯片变更订单录入列表
	 * @author: zhuoHeng
	 * @version: 2016年10月14日 下午2:17:44
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:view")
	@RequestMapping(value = {"orderList"})
	public String orderList(DogChipChange dogChipChange, HttpServletRequest request, HttpServletResponse response, Model model) {
		List<DogChipChange> list = dogChipChangeService.findList(dogChipChange); 
		model.addAttribute("list", list);
		return "oa/dog/dogchipchangemanage/dogChipChangeOrderList";
	}
	
	/**
	 * 
	 * @Description：芯片变更订单业务添加页
	 * @author: zhuoHeng
	 * @version: 2016年10月14日 下午2:19:32
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(DogChipChange dogChipChange, Model model,
			@RequestParam(required=true)String chargingItemId,
			@RequestParam(required=true)String memberCode) {
		dogChipChange.setPaymentMemberCode(memberCode);
		model.addAttribute("dogChipChange", dogChipChange);
		return "oa/dog/dogchipchangemanage/dogChipChangeOrderAdd";
	}
	
	/**
	 * 
	 * @Description：芯片变更业务信息保存
	 * @author: zhuoHeng
	 * @version: 2016年10月14日 下午2:19:40
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderSave")
	@ResponseBody
	public Object orderSave(DogChipChange dogChipChange, Model model,HttpServletRequest request) {
		HashMap<String,String> map = new HashMap<String,String>();
		map.put("rc", "0");
		try {
			String check = request.getParameter("check");//选中的登记类型
			String birthCerRegCodeHid = request.getParameter("birthCerRegCodeHid");//出生纸编号
			dogChipChangeService.orderSave(dogChipChange,check,birthCerRegCodeHid);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
}