package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBreedCertified;
import com.cku.oa.dog.entity.DogBreedPrint;
import com.cku.oa.dog.entity.DogOwnerChange;
import com.cku.oa.dog.entity.DogPedigreeCertifiedExport;
import com.cku.oa.dog.service.DogBreedCertifiedService;
import com.cku.oa.show.entity.ChampionLogin;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 繁育证书Controller
 * @author zhuoHeng
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "${adminPath}/dogbreed/dogBreedCertified")
public class DogBreedCertifiedController extends BaseController {

	@Autowired
	private DogBreedCertifiedService dogBreedCertifiedService;
	
	@ModelAttribute
	public DogBreedCertified get(@RequestParam(required=false) String id) {
		DogBreedCertified entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogBreedCertifiedService.get(id);
		}
		if (entity == null){
			entity = new DogBreedCertified();
		}
		return entity;
	}
	
	@RequiresPermissions("dogbreed:dogBreedCertified:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogBreedCertified dogBreedCertified, HttpServletRequest request, HttpServletResponse response, Model model) {
		String dogBreed = request.getParameter("dogBreed");
		if("230".equals(dogBreed)&&dogBreedCertified.getDog()==null){
			dogBreedCertified.setDogBreed(dogBreed);
		}
		Page<DogBreedCertified> page = dogBreedCertifiedService.findPage(new Page<DogBreedCertified>(request, response), dogBreedCertified); 
		model.addAttribute("page", page);
		if("230".equals(dogBreed)){
			return "oa/dog/dogbreed/dogBreedCertifiedListTibetanMastiff";
		} else {
			return "oa/dog/dogbreed/dogBreedCertifiedList";
		}
	}

	@RequiresPermissions("dogbreed:dogBreedCertified:view")
	@RequestMapping(value = "form")
	public String form(DogBreedCertified dogBreedCertified, Model model) {
		model.addAttribute("dogBreedCertified", dogBreedCertified);
		model.addAttribute("childShowsList",dogBreedCertified.getChildShowsList());
		return "oa/dog/dogbreed/dogBreedCertifiedForm";
	}

	@RequiresPermissions("dogbreed:dogBreedCertified:edit")
	@RequestMapping(value = "save")
	public String save(DogBreedCertified dogBreedCertified, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogBreedCertified)){
			return form(dogBreedCertified, model);
		}
		dogBreedCertifiedService.save(dogBreedCertified);
		addMessage(redirectAttributes, "保存繁育证书成功");
		return "redirect:"+Global.getAdminPath()+"/dogbreed/dogBreedCertified/?repage";
	}
	
	@RequiresPermissions("dogbreed:dogBreedCertified:delete")
	@RequestMapping(value = "delete")
	public String delete(DogBreedCertified dogBreedCertified, RedirectAttributes redirectAttributes) {
		dogBreedCertifiedService.delete(dogBreedCertified);
		addMessage(redirectAttributes, "删除繁育证书成功");
		return "redirect:"+Global.getAdminPath()+"/dogbreed/dogBreedCertified/?repage";
	}

	/**
     * 
     * @Description：保存繁育证书
     * @author: zhuoHeng
     * @version: 2016年8月23日 下午5:47:03
     */
    @RequiresPermissions("dogbreed:dogBreedCertified:edit")
    @RequestMapping(value = "edit")
    public String edit(DogBreedCertified dogBreedCertified, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, dogBreedCertified)){
            return form(dogBreedCertified, model);
        }
        dogBreedCertifiedService.edit(dogBreedCertified);
        addMessage(redirectAttributes, "保存繁育证书成功");
        return "redirect:"+Global.getAdminPath()+"/dogbreed/dogBreedCertified/?repage";
    }
    
    /**
     * 
     * @Description：更改繁育证书处理状态并生成繁育证书编号
     * @author: zhuoHeng
     * @version: 2016年8月24日 上午11:43:15
     */
    @RequiresPermissions("dogbreed:dogBreedCertified:process")
    @RequestMapping(value = "process")
    @ResponseBody
    public String process(DogBreedCertified dogBreedCertified,Model model){
        if (!beanValidator(model, dogBreedCertified)){
            return "{\"rc\":-1,\"msg\":\"error\"}";
        }
        try{
            dogBreedCertifiedService.changeProcessState(dogBreedCertified);
        } catch (ZAException e) {
            return "{\"rc\":"+e.get_code()+",\"msg\":\""+e.getMessage()+"\"}";
        }
        return "{\"rc\":0,\"msg\":\"success\"}";
    }
    
    /**
     * 
     * @Description：繁育证书查看页
     * @author: zhuoHeng
     * @version: 2016年8月27日 下午4:45:53
     */
    @RequiresPermissions("dogbreed:dogBreedCertified:view")
    @RequestMapping(value = "view")
    public String view(DogBreedCertified dogBreedCertified, Model model) {
        model.addAttribute("dogBreedCertified", dogBreedCertified);
        model.addAttribute("childShowsList",dogBreedCertified.getChildShowsList());
        return "oa/dog/dogbreed/dogBreedCertifiedView";
    }
    
    /**
     * 
     * @Description：繁育证书打印
     * @author: zhuoHeng
     * @version: 2016年9月2日 上午10:34:16
     */
    @RequiresPermissions("dogbreed:dogBreedCertified:print")
    @RequestMapping(value = "print")
    public String print(DogBreedCertified dogBreedCertified, HttpServletRequest request, HttpServletResponse response, Model model) {
        model.addAttribute("dogBreedCertified", dogBreedCertified);
        dogBreedCertifiedService.print(dogBreedCertified);
        return "oa/dog/dogbreed/dogBreedCertifiedPrint";
    }
    
    /**
     * 
     * @Description：重置繁育证书打印状态
     * @author: zhuoHeng
     * @version: 2016年9月5日 下午3:22:43
     */
    @RequiresPermissions("dogbreed:dogBreedCertified:resetPrint")
    @RequestMapping(value = "resetPrint")
    public String resetPrint(DogBreedCertified dogBreedCertified, RedirectAttributes redirectAttributes) {
    	dogBreedCertifiedService.resetPrint(dogBreedCertified);
        addMessage(redirectAttributes, "重置繁育证书打印成功");
        return "redirect:"+Global.getAdminPath()+"/dogbreed/dogBreedCertified/?repage";
    }
    
    /**
     * 
     * @Description：获取繁育证书打印所需信息
     * @author: zhuoHeng
     * @version: 2016年9月2日 上午10:41:47
     */
    @RequestMapping(value = "getPrintMessage")
    @ResponseBody
    public String getPrintMessage(HttpServletRequest request){
        String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
        String dogId = request.getParameter("dogId");
        String dogBreedPrint = dogBreedCertifiedService.getPrintMessage(fmdogBreedCertifiedCode,dogId);
        return dogBreedPrint;
    }
    
    /**
     * 
     * @Description：繁育证书订单录入列表
     * @author: zhuoHeng
     * @version: 2016年9月5日 下午4:30:25
     */
    @RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogBreedCertified dogBreedCertified, Model model) {
		List<DogBreedCertified> list = dogBreedCertifiedService.findList(dogBreedCertified);
		model.addAttribute("list", list);
		return "oa/dog/dogbreed/dogBreedCertifiedOrderList";
	}
    
    /**
     * 
     * @Description：繁育证书订单录入页
     * @author: zhuoHeng
     * @version: 2016年9月5日 下午5:00:37
     */
    @RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(DogBreedCertified dogBreedCertified,@RequestParam(required=true)String runningNumber,
			@RequestParam(required=true)String chargingItemId,
			@RequestParam(required=true)String memberCode,
			Model model) {
		model.addAttribute("dogBreedCertified", dogBreedCertified);
		model.addAttribute("memberCode", memberCode);
		return "oa/dog/dogbreed/dogBreedCertifiedOrderAdd";
	}
    
    /**
     * 
     * @Description：繁育证书业务信息录入
     * @author: zhuoHeng
     * @version: 2016年9月5日 下午5:59:24
     */
    @RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
    @ResponseBody
	public Object add(DogBreedCertified dogBreedCertified, Model model, RedirectAttributes redirectAttributes) {
    	HashMap<String,String> map = new HashMap<String,String>();
		map.put("rc", "0");
		try {
			dogBreedCertifiedService.add(dogBreedCertified);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
    
    /**
     * 
     * @Description：订单列表页删除
     * @author: zhuoHeng
     * @version: 2016年9月5日 下午7:07:25
     */
    @RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderDelete")
	public String orderDelete(DogBreedCertified dogBreedCertified, RedirectAttributes redirectAttributes,Model model) {
    	if (!beanValidator(model, dogBreedCertified)){
            return form(dogBreedCertified, model);
        }
    	String runningNumber = dogBreedCertified.getRunningNumber();
		dogBreedCertifiedService.delete(dogBreedCertified);
		addMessage(redirectAttributes, "删除繁育证书成功");
		return "redirect:"+Global.getAdminPath()+"/dogbreed/dogBreedCertified/orderList/?runningNumber="+runningNumber+"&repage";
	}
    
    /**
     * 
     * @Description：繁育证书审核页
     * @author: zhuoHeng
     * @version: 2016年10月11日 下午5:49:14
     */
    @RequiresPermissions("dogbreed:dogBreedCertified:audit")
    @RequestMapping(value = "audit")
    public String audit(DogBreedCertified dogBreedCertified, Model model) {
        model.addAttribute("dogBreedCertified", dogBreedCertified);
        model.addAttribute("childShowsList",dogBreedCertified.getChildShowsList());
        return "oa/dog/dogbreed/dogBreedCertifiedReview";
    }
    
    /**
     * 
     * @Description：繁育证书审核更改状态
     * @author: zhuoHeng
     * @version: 2016年10月12日 上午9:55:19
     */
    @RequiresPermissions("dogbreed:dogBreedCertified:audit")
	@RequestMapping(value = "review")
    @ResponseBody
	public String review(DogBreedCertified dogBreedCertified,Model model,RedirectAttributes redirectAttributes){
	    if (!beanValidator(model, dogBreedCertified)){
	    	return form(dogBreedCertified, model);
        }
	    try{
	    	dogBreedCertifiedService.changeStatus(dogBreedCertified);
        } catch (ZAException e) {
        	return "{\"rc\":"+e.get_code()+",\"msg\":\""+e.getMessage()+"\"}";
        }
	    return "{\"rc\":0,\"msg\":\"success\"}";
	}
}