/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.cku.oa.sys.entity.user.Member;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

import java.util.Date;

/**
 * 犬只鼻纹Entity
 * 
 * @author xx
 * @version 2020-04-23
 */
public class DogNose extends DataEntity<DogNose> {

	private static final long serialVersionUID = 1L;
	private String dogBirthCertificateId; // 登记卡表主键
	private String dogId; // 犬只表主键
	private String noseCode; // 鼻纹编号
	private String noseId; // 鼻纹ID-第三方

	private String relationFlag; // 1 合并查询  dogBirthCertificateId or noseId

	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date
	private String state;//鼻纹状态
	private Member member;
	private DogBirthCertificate dogBirthCertificate;

	public String getRelationFlag() {
		return relationFlag;
	}

	public void setRelationFlag(String relationFlag) {
		this.relationFlag = relationFlag;
	}

	public DogNose() {
		super();
	}

	public DogNose(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "登记卡表主键长度必须介于 0 和 64 之间")
	public String getDogBirthCertificateId() {
		return dogBirthCertificateId;
	}

	public void setDogBirthCertificateId(String dogBirthCertificateId) {
		this.dogBirthCertificateId = dogBirthCertificateId;
	}

	@Length(min = 0, max = 64, message = "犬只表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	@Length(min = 0, max = 64, message = "鼻纹编号长度必须介于 0 和 64 之间")
	public String getNoseCode() {
		return noseCode;
	}

	public void setNoseCode(String noseCode) {
		this.noseCode = noseCode;
	}

	@Length(min = 0, max = 64, message = "鼻纹ID-第三方长度必须介于 0 和 64 之间")
	public String getNoseId() {
		return noseId;
	}

	public void setNoseId(String noseId) {
		this.noseId = noseId;
	}

	public DogBirthCertificate getDogBirthCertificate() {
		return dogBirthCertificate;
	}

	public void setDogBirthCertificate(DogBirthCertificate dogBirthCertificate) {
		this.dogBirthCertificate = dogBirthCertificate;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}
}