/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

import com.cku.oa.show.entity.ShowResults;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 犬只信息管理Entity
 *
 * @author zhuoHeng
 * @version 2016-08-03
 */
public class Dog extends DataEntity<Dog> {

	private static final long serialVersionUID = 1L;
	private String logout; // 犬只注销
	private String birthCertificateLevelCode; // 出生证明登记编号
	@ExcelField(title = "血统证书号", align = 2, sort = 1)
	private String pedigreeCertifiedCode; // 血统证书号
	@ExcelField(title = "犬主姓名", align = 2, sort = 11)
	private String dogOwner; // 犬主人
	@ExcelField(title = "犬主会员号", align = 2, sort = 10)
	private String memberCode; // 会员号
	private String secondDogOwner; // 第二犬主人
	private String secondOwnerMemberNum; // 第二犬主会员号
	@ExcelField(title = "繁殖人", align = 2, sort = 19)
	private String breeder; // 繁殖人
	private String secondBreeder; // 第二繁殖人
	@ExcelField(title = "犬只中文名", align = 2, sort = 2)
	private String nameCn; // 中文姓名
	@ExcelField(title = "犬只英文名", align = 2, sort = 3)
	private String nameEn; // 英文姓名
	private String nickname; // 呼名
	@ExcelField(title = "性别", align = 2, sort = 4)
	private String gender; // 性别
	@ExcelField(title = "犬种", align = 2, sort = 5)
	private String dogBreed; // 种类
	@ExcelField(title = "FCI犬种", align = 2, sort = 6)
	private String showDogBreed; // 赛事种类
	@ExcelField(title = "出生日期", align = 2, sort = 7)
	private Date birthdate; // 出生日期
	@ExcelField(title = "芯片号", align = 2, sort = 8)
	private String identificationFlag; // 身份识别标记
	private String dnaSaveWay; // DNA留存方式:血样留存0；DNA位点分析1
	private String isDnaParentsCompare; // DNA双亲比对标记位：0否；1是
	// 金质证书类型（0:旧数据1:升级2:申请）
	private Integer goldCertifiedType;
	// 金质证书状态（0:降级1:正常）
	private Integer goldCertifiedState;
	private String wool; // 毛制
	@ExcelField(title = "毛色", align = 2, sort = 1)
	private String colorFlag; // 颜色及标志
	private String specialFlag; // 特殊标志
	private String hipQualificationResult; // 髋关节鉴定结果
	private String elbowQualificationResult; // 肘关节鉴定结果
	private String dna; // DNA
	private String samplingCode; // 采样包编号
	private String breedQualification; // 繁殖资格
	private String inbreeding; // 近亲繁殖
	private String refereeEvaluation; // 裁判评价
	private String showLevel; // 比赛级别
	private String showGrade; // 比赛成绩
	private String testLevel; // 考试级别
	private String testGrade; // 比赛成绩
	private String archivesCode; // 档案号
	@ExcelField(title = "父犬证书号", align = 2, sort = 21)
	private String fdogPedigreeCertified; // 父犬血统证书号
	@ExcelField(title = "母犬证书号", align = 2, sort = 22)
	private String mdogPedigreeCertified; // 母犬血统证书号
	@ExcelField(title = "父母犬配种证明号", align = 2, sort = 20)
	private String fmdogBreedCertifiedCode; // 父母犬配犬证明号
	private String inbreedingPrint; // 近亲繁殖打印
	private String printState; // 打印状态
	private Date printTime; // 打印时间
	private String pedigreeCertifiedOld; //s 旧血统证书号
	@ExcelField(title = "国外血统证书号", align = 2, sort = 15)
	private String pedigreeCertifiedEn; // 国外血统证书号
	private String operator; // 操作人
	private String dnaPayState; // DNA付款状态
	private String breedPayState; // 繁育付款状态
	private String runningNumber; // 流水号
	private String breederMemberCode; // 繁育人会员号
	@ExcelField(title = "代数", align = 2, sort = 18)
	private String dogGeneration; // 几代血统
	private String breedReviewe; // 繁育审核
	private String disqualificationNumber; // 失格次数
	private ShowResults showResults; // 犬只全犬种成绩实体
	private String dogType; // 犬种拼接
	private String dogState; // 犬只状态
	private String businessBan; // 业务禁止：0正常；1禁止繁殖(禁止提交配种证明，出生纸；禁止报名比赛；禁止办理出口血统证书)
	private String showBan; // 赛事禁止：0正常 ；1禁止
	private String changeBan; // 出口禁止 0正常 1禁止
	private String studDogId; // 种公信息表id
	private String studDogState; // 种公上架状态
	private String studDogCoverImgId; // 种公封面图片id
	private String dogOwnerSite; // 狗主人会员类型
	private String birthdateYear; // 出生年份
	private String callName; // 呼名
	private String cabPassport;// 护照号
	private String cabPassportLike;// 护照号模糊查询字段
	@ExcelField(title = "备注", align = 2, sort = 50)
	private String importRemark; // 导入用备注

	private String cabRegisterCode; // 宠爱登记卡号

	private Character useDogAgeFlag;// 犬舍评选系统二期查询犬只信息，增加条件：犬龄大于12个月，dogAgeFlag =1

	private String ecertFlag;

	private String picture;
	private String pictureReviewRemark;

	private String pictureReviewState;// 审核状态 0待审核、1已通过、2未通过
	private String noseFlag;// 鼻纹状态 1已采集、2未采集
	
	private String dogPedigreeCertifiedRedoId;
	
	private String breedClass;//犬种分类 FCI正式品种:formal、FCI临时认可品种:temp、FCI国家级认可品种:country、FCI不认可品种:unauth

	public String getBreedClass() {
		return breedClass;
	}

	public void setBreedClass(String breedClass) {
		this.breedClass = breedClass;
	}
	private String changeBanBase64;

	public String getNoseFlag() {
		return noseFlag;
	}

	public void setNoseFlag(String noseFlag) {
		this.noseFlag = noseFlag;
	}

	public String getPictureReviewRemark() {
		return pictureReviewRemark;
	}

	public void setPictureReviewRemark(String pictureReviewRemark) {
		this.pictureReviewRemark = pictureReviewRemark;
	}

	public String getPicture() {
		return picture;
	}

	public void setPicture(String picture) {
		this.picture = picture;
	}

	public String getPictureReviewState() {
		return pictureReviewState;
	}

	public void setPictureReviewState(String pictureReviewState) {
		this.pictureReviewState = pictureReviewState;
	}

	public String getSecondBreeder() {
		return secondBreeder;
	}

	public void setSecondBreeder(String secondBreeder) {
		this.secondBreeder = secondBreeder;
	}

	public Character getUseDogAgeFlag() {
		return useDogAgeFlag;
	}

	public void setUseDogAgeFlag(Character useDogAgeFlag) {
		this.useDogAgeFlag = useDogAgeFlag;
	}

	public String getCabRegisterCode() {
		return cabRegisterCode;
	}

	public void setCabRegisterCode(String cabRegisterCode) {
		this.cabRegisterCode = cabRegisterCode;
	}

	public Dog() {
		super();
	}

	public Dog(String id) {
		super(id);
	}

	@Length(min = 0, max = 1, message = "犬只注销长度必须介于 0 和 1 之间")
	public String getLogout() {
		return logout;
	}

	public void setLogout(String logout) {
		this.logout = logout;
	}

	@Length(min = 0, max = 64, message = "出生证明登记编号长度必须介于 0 和 64 之间")
	public String getBirthCertificateLevelCode() {
		return birthCertificateLevelCode;
	}

	public void setBirthCertificateLevelCode(String birthCertificateLevelCode) {
		this.birthCertificateLevelCode = birthCertificateLevelCode;
	}

	@Length(min = 0, max = 64, message = "血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertifiedCode() {
		return pedigreeCertifiedCode;
	}

	public void setPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		this.pedigreeCertifiedCode = pedigreeCertifiedCode;
	}

	@Length(min = 0, max = 64, message = "犬主人长度必须介于 0 和 64 之间")
	public String getDogOwner() {
		return dogOwner;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}

	@Length(min = 0, max = 100, message = "会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "第二犬主人长度必须介于 0 和 64 之间")
	public String getSecondDogOwner() {
		return secondDogOwner;
	}

	public void setSecondDogOwner(String secondDogOwner) {
		this.secondDogOwner = secondDogOwner;
	}

	@Length(min = 0, max = 64, message = "第二犬主会员号长度必须介于 0 和 64 之间")
	public String getSecondOwnerMemberNum() {
		return secondOwnerMemberNum;
	}

	public void setSecondOwnerMemberNum(String secondOwnerMemberNum) {
		this.secondOwnerMemberNum = secondOwnerMemberNum;
	}

	@Length(min = 0, max = 64, message = "繁殖人长度必须介于 0 和 64 之间")
	public String getBreeder() {
		return breeder;
	}

	public void setBreeder(String breeder) {
		this.breeder = breeder;
	}

	@Length(min = 0, max = 64, message = "中文姓名长度必须介于 0 和 64 之间")
	public String getNameCn() {
		return nameCn;
	}

	public void setNameCn(String nameCn) {
		this.nameCn = nameCn;
	}

	@Length(min = 0, max = 255, message = "英文姓名长度必须介于 0 和 255 之间")
	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	@Length(min = 0, max = 10, message = "性别长度必须介于 0 和 10 之间")
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	@Length(min = 0, max = 64, message = "种类长度必须介于 0 和 64 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBirthdate() {
		return birthdate;
	}

	public void setBirthdate(Date birthdate) {
		this.birthdate = birthdate;
	}

	@Length(min = 0, max = 64, message = "身份识别标记长度必须介于 0 和 64 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	public String getDnaSaveWay() {
		return dnaSaveWay;
	}

	public void setDnaSaveWay(String dnaSaveWay) {
		this.dnaSaveWay = dnaSaveWay;
	}

	public String getIsDnaParentsCompare() {
		return isDnaParentsCompare;
	}

	public void setIsDnaParentsCompare(String isDnaParentsCompare) {
		this.isDnaParentsCompare = isDnaParentsCompare;
	}

	public Integer getGoldCertifiedType() {
		return goldCertifiedType;
	}

	public void setGoldCertifiedType(Integer goldCertifiedType) {
		this.goldCertifiedType = goldCertifiedType;
	}

	public Integer getGoldCertifiedState() {
		return goldCertifiedState;
	}

	public void setGoldCertifiedState(Integer goldCertifiedState) {
		this.goldCertifiedState = goldCertifiedState;
	}

	@Length(min = 0, max = 64, message = "毛制长度必须介于 0 和 64 之间")
	public String getWool() {
		return wool;
	}

	public void setWool(String wool) {
		this.wool = wool;
	}

	@Length(min = 0, max = 64, message = "颜色及标志长度必须介于 0 和 64 之间")
	public String getColorFlag() {
		if(StringUtils.isNotBlank(colorFlag) ) {
			return StringEscapeUtils.unescapeHtml4(colorFlag.replace("&AMP;", "&amp;"));
		}
		return colorFlag;
	}

	public void setColorFlag(String colorFlag) {
		this.colorFlag = colorFlag;
	}

	@Length(min = 0, max = 64, message = "特殊标志长度必须介于 0 和 64 之间")
	public String getSpecialFlag() {
		return specialFlag;
	}

	public void setSpecialFlag(String specialFlag) {
		this.specialFlag = specialFlag;
	}

	@Length(min = 0, max = 255, message = "髋关节鉴定结果长度必须介于 0 和 255 之间")
	public String getHipQualificationResult() {
		return hipQualificationResult;
	}

	public void setHipQualificationResult(String hipQualificationResult) {
		this.hipQualificationResult = hipQualificationResult;
	}

	@Length(min = 0, max = 64, message = "肘关节鉴定结果长度必须介于 0 和 64 之间")
	public String getElbowQualificationResult() {
		return elbowQualificationResult;
	}

	public void setElbowQualificationResult(String elbowQualificationResult) {
		this.elbowQualificationResult = elbowQualificationResult;
	}

	@Length(min = 0, max = 64, message = "DNA长度必须介于 0 和 64 之间")
	public String getDna() {
		return dna;
	}

	public void setDna(String dna) {
		this.dna = dna;
	}

	public String getSamplingCode() {
		return samplingCode;
	}

	public void setSamplingCode(String samplingCode) {
		this.samplingCode = samplingCode;
	}

	@Length(min = 0, max = 64, message = "繁殖资格长度必须介于 0 和 64 之间")
	public String getBreedQualification() {
		return breedQualification;
	}

	public void setBreedQualification(String breedQualification) {
		this.breedQualification = breedQualification;
	}

	@Length(min = 0, max = 64, message = "近亲繁殖长度必须介于 0 和 64 之间")
	public String getInbreeding() {
		return inbreeding;
	}

	public void setInbreeding(String inbreeding) {
		this.inbreeding = inbreeding;
	}

	@Length(min = 0, max = 500, message = "裁判评价长度必须介于 0 和 500 之间")
	public String getRefereeEvaluation() {
		return refereeEvaluation;
	}

	public void setRefereeEvaluation(String refereeEvaluation) {
		this.refereeEvaluation = refereeEvaluation;
	}

	@Length(min = 0, max = 64, message = "比赛级别长度必须介于 0 和 64 之间")
	public String getShowLevel() {
		return showLevel;
	}

	public void setShowLevel(String showLevel) {
		this.showLevel = showLevel;
	}

	@Length(min = 0, max = 100, message = "比赛成绩长度必须介于 0 和 100 之间")
	public String getShowGrade() {
		return showGrade;
	}

	public void setShowGrade(String showGrade) {
		this.showGrade = showGrade;
	}

	@Length(min = 0, max = 64, message = "考试级别长度必须介于 0 和 64 之间")
	public String getTestLevel() {
		return testLevel;
	}

	public void setTestLevel(String testLevel) {
		this.testLevel = testLevel;
	}

	@Length(min = 0, max = 100, message = "比赛成绩长度必须介于 0 和 100 之间")
	public String getTestGrade() {
		return testGrade;
	}

	public void setTestGrade(String testGrade) {
		this.testGrade = testGrade;
	}

	@Length(min = 0, max = 100, message = "档案号长度必须介于 0 和 100 之间")
	public String getArchivesCode() {
		return archivesCode;
	}

	public void setArchivesCode(String archivesCode) {
		this.archivesCode = archivesCode;
	}

	@Length(min = 0, max = 100, message = "父犬血统证书号长度必须介于 0 和 100 之间")
	public String getFdogPedigreeCertified() {
		return fdogPedigreeCertified;
	}

	public void setFdogPedigreeCertified(String fdogPedigreeCertified) {
		this.fdogPedigreeCertified = fdogPedigreeCertified;
	}

	@Length(min = 0, max = 100, message = "母犬血统证书号长度必须介于 0 和 100 之间")
	public String getMdogPedigreeCertified() {
		return mdogPedigreeCertified;
	}

	public void setMdogPedigreeCertified(String mdogPedigreeCertified) {
		this.mdogPedigreeCertified = mdogPedigreeCertified;
	}

	@Length(min = 0, max = 100, message = "父母犬配犬证明号长度必须介于 0 和 100 之间")
	public String getFmdogBreedCertifiedCode() {
		return fmdogBreedCertifiedCode;
	}

	public void setFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		this.fmdogBreedCertifiedCode = fmdogBreedCertifiedCode;
	}

	@Length(min = 0, max = 64, message = "近亲繁殖打印长度必须介于 0 和 64 之间")
	public String getInbreedingPrint() {
		return inbreedingPrint;
	}

	public void setInbreedingPrint(String inbreedingPrint) {
		this.inbreedingPrint = inbreedingPrint;
	}

	@Length(min = 0, max = 64, message = "打印状态长度必须介于 0 和 64 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	@Length(min = 0, max = 64, message = "旧血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertifiedOld() {
		return pedigreeCertifiedOld;
	}

	public void setPedigreeCertifiedOld(String pedigreeCertifiedOld) {
		this.pedigreeCertifiedOld = pedigreeCertifiedOld;
	}

	@Length(min = 0, max = 64, message = "国外血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertifiedEn() {
		return pedigreeCertifiedEn;
	}

	public void setPedigreeCertifiedEn(String pedigreeCertifiedEn) {
		this.pedigreeCertifiedEn = pedigreeCertifiedEn;
	}

	@Length(min = 0, max = 2000, message = "操作人长度必须介于 0 和 2000 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	@Length(min = 0, max = 10, message = "DNA付款状态长度必须介于 0 和 10 之间")
	public String getDnaPayState() {
		return dnaPayState;
	}

	public void setDnaPayState(String dnaPayState) {
		this.dnaPayState = dnaPayState;
	}

	@Length(min = 0, max = 10, message = "繁育付款状态长度必须介于 0 和 10 之间")
	public String getBreedPayState() {
		return breedPayState;
	}

	public void setBreedPayState(String breedPayState) {
		this.breedPayState = breedPayState;
	}

	@Length(min = 0, max = 255, message = "流水号长度必须介于 0 和 255 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 64, message = "繁育人会员号长度必须介于 0 和 64 之间")
	public String getBreederMemberCode() {
		return breederMemberCode;
	}

	public void setBreederMemberCode(String breederMemberCode) {
		this.breederMemberCode = breederMemberCode;
	}

	@Length(min = 0, max = 20, message = "几代血统长度必须介于 0 和 20 之间")
	public String getDogGeneration() {
		return dogGeneration;
	}

	public void setDogGeneration(String dogGeneration) {
		this.dogGeneration = dogGeneration;
	}

	@Length(min = 0, max = 50, message = "繁育审核长度必须介于 0 和 50 之间")
	public String getBreedReviewe() {
		return breedReviewe;
	}

	public void setBreedReviewe(String breedReviewe) {
		this.breedReviewe = breedReviewe;
	}

	@Length(min = 0, max = 11, message = "失格次数长度必须介于 0 和 11 之间")
	public String getDisqualificationNumber() {
		return disqualificationNumber;
	}

	public void setDisqualificationNumber(String disqualificationNumber) {
		this.disqualificationNumber = disqualificationNumber;
	}

	public ShowResults getShowResults() {
		return showResults;
	}

	public void setShowResults(ShowResults showResults) {
		this.showResults = showResults;
	}

	public String getDogType() {
		return dogType;
	}

	public void setDogType(String dogType) {
		this.dogType = dogType;
	}

	public String getDogState() {
		return dogState;
	}

	public void setDogState(String dogState) {
		this.dogState = dogState;
	}

	public String getBusinessBan() {
		return businessBan;
	}

	public void setBusinessBan(String businessBan) {
		this.businessBan = businessBan;
	}

	public String getStudDogId() {
		return studDogId;
	}

	public void setStudDogId(String studDogId) {
		this.studDogId = studDogId;
	}

	public String getStudDogState() {
		return studDogState;
	}

	public void setStudDogState(String studDogState) {
		this.studDogState = studDogState;
	}

	public String getStudDogCoverImgId() {
		return studDogCoverImgId;
	}

	public void setStudDogCoverImgId(String studDogCoverImgId) {
		this.studDogCoverImgId = studDogCoverImgId;
	}

	public String getBirthdateYear() {
		return birthdateYear;
	}

	public void setBirthdateYear(String birthdateYear) {
		this.birthdateYear = birthdateYear;
	}

	public String getCallName() {
		return callName;
	}

	public void setCallName(String callName) {
		this.callName = callName;
	}

	public String getShowDogBreed() {
		return showDogBreed;
	}

	public void setShowDogBreed(String showDogBreed) {
		this.showDogBreed = showDogBreed;
	}

	public String getCabPassport() {
		return cabPassport;
	}

	public void setCabPassport(String cabPassport) {
		this.cabPassport = cabPassport;
	}

	public String getCabPassportLike() {
		return cabPassportLike;
	}

	public void setCabPassportLike(String cabPassportLike) {
		this.cabPassportLike = cabPassportLike;
	}

	public String getShowBan() {
		return showBan;
	}

	public void setShowBan(String showBan) {
		this.showBan = showBan;
	}

	public String getImportRemark() {
		return importRemark;
	}

	public void setImportRemark(String importRemark) {
		this.importRemark = importRemark;
	}

	public String getDogOwnerSite() {
		return dogOwnerSite;
	}

	public void setDogOwnerSite(String dogOwnerSite) {
		this.dogOwnerSite = dogOwnerSite;
	}

	public String getEcertFlag() {
		return ecertFlag;
	}

	public void setEcertFlag(String ecertFlag) {
		this.ecertFlag = ecertFlag;
	}

	public String getDogPedigreeCertifiedRedoId() {
		return dogPedigreeCertifiedRedoId;
	}

	public void setDogPedigreeCertifiedRedoId(String dogPedigreeCertifiedRedoId) {
		this.dogPedigreeCertifiedRedoId = dogPedigreeCertifiedRedoId;
	}

	public Date getPrintTime() {
		return printTime;
	}

	public void setPrintTime(Date printTime) {
		this.printTime = printTime;
	}

	public String getChangeBan() {
		return changeBan;
	}

	public void setChangeBan(String changeBan) {
		this.changeBan = changeBan;
	}

	public String getChangeBanBase64() {
		return changeBanBase64;
	}

	public void setChangeBanBase64(String changeBanBase64) {
		this.changeBanBase64 = changeBanBase64;
	}
	
	
	
}