/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.dog.entity.DogSecondBreeder;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 第二繁殖人DAO接口
 * @author wj
 * @version 2020-08-13
 */
@MyBatisDao
public interface DogSecondBreederDao extends CrudDao<DogSecondBreeder> {

    List<DogSecondBreeder> getByBreedCertifiedCode(@Param("breedCertifiedCode") String breedCertifiedCode);
    DogSecondBreeder getByBreedCertifiedCodeAndOrderCode(@Param("breedCertifiedCode") String breedCertifiedCode,@Param("orderCode")String orderCode);
    List<DogSecondBreeder> getByBreedCertifiedCodes ( @Param("ids") Set<String> ids);

    List<DogSecondBreeder> getByRunningNumber(@Param("runningNumber") String runningNumber);
}