package com.cku.oa.breeder.web;

import com.cku.oa.breeder.entity.StudDog;
import com.cku.oa.breeder.service.StudDogService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 种公信息Controller
 *
 * @author lgl
 * @version 2017-10-13
 */
@Controller
@RequestMapping(value = "${adminPath}/studdog/studDog")
public class StudDogController extends BaseController {

    @Autowired
    private StudDogService studDogService;

    @ModelAttribute
    public StudDog get(@RequestParam(required = false) String id) {
        StudDog entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = studDogService.get(id);
        }
        if (entity == null) {
            entity = new StudDog();
        }
        return entity;
    }

    @RequiresPermissions("studdog:studDog:view")
    @RequestMapping(value = {"list", ""})
    public String list(StudDog studDog, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<StudDog> page = studDogService.findPage(new Page<StudDog>(request, response), studDog);
        model.addAttribute("page", page);
        return "breeder/studdog/studDogList";
    }

    @RequiresPermissions("studdog:studDog:view")
    @RequestMapping(value = "form")
    public String form(StudDog studDog, Model model) {
        model.addAttribute("studDog", studDog);
        return "breeder/studdog/studDogForm";
    }

    @RequiresPermissions("studdog:studDog:edit")
    @RequestMapping(value = "save")
    public String save(StudDog studDog, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, studDog)) {
            return form(studDog, model);
        }
        studDogService.save(studDog);
        addMessage(redirectAttributes, "保存种公信息成功");
        return "redirect:" + Global.getAdminPath() + "/studdog/studDog/?repage";
    }

    @RequiresPermissions("studdog:studDog:edit")
    @RequestMapping(value = "delete")
    public String delete(StudDog studDog, RedirectAttributes redirectAttributes) {
        studDogService.delete(studDog);
        addMessage(redirectAttributes, "删除种公信息成功");
        return "redirect:" + Global.getAdminPath() + "/studdog/studDog/?repage";
    }

}