/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.breeder.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 种公信息Entity
 *
 * @author lgl
 * @version 2017-10-13
 */
public class StudDog extends DataEntity<StudDog> {

    private static final long serialVersionUID = 1L;
    private String dogId;        // 犬id
    private String state;        // 状态：0未上架；1已上架
    private String pedigreeCertified;        // 犬只血统证书号
    private String dogBreed;        // 犬种号
    private String memberCode;        // 犬主会员号
    private String price;        // 配种价格
    private String doorToDoorFlag;        // 是否可以上门配种标记位。0不可以；1可以
    private String label;        // 主标签，不可修改
    private String otherLabel;        // 其他标签，可修改
    private String recommendInfo;        // 推荐信息
    private String coverImgId;        // 封面图片id
    private String otherImgId;        // 其他图片id，逗号分隔
    private String dogNewbornCount;        // 配种次数
    private Date addTime;        // 上架时间

    private String nickname;        // 呼名
    private Date birthdate;        // 出生日期
    private String nameEn;        // 英文姓名

    private String city;        // 城市
    private String age;        // 年龄
    private String dogPedigreeCertifiedChangeId;		// 国外血统证书号
    private String viewCount;       // 查看次数
    private String viewCountFlag;       // 增加查看次数标记位

    public StudDog() {
        super();
    }

    public StudDog(String id) {
        super(id);
    }

    @Length(min = 1, max = 64, message = "犬id长度必须介于 1 和 64 之间")
    public String getDogId() {
        return dogId;
    }

    public void setDogId(String dogId) {
        this.dogId = dogId;
    }

    @Length(min = 1, max = 2, message = "状态：0未上架；1已上架长度必须介于 1 和 2 之间")
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Length(min = 1, max = 64, message = "犬只血统证书号长度必须介于 1 和 64 之间")
    public String getPedigreeCertified() {
        return pedigreeCertified;
    }

    public void setPedigreeCertified(String pedigreeCertified) {
        this.pedigreeCertified = pedigreeCertified;
    }

    @Length(min = 1, max = 20, message = "犬种号长度必须介于 1 和 20 之间")
    public String getDogBreed() {
        return dogBreed;
    }

    public void setDogBreed(String dogBreed) {
        this.dogBreed = dogBreed;
    }

    @Length(min = 1, max = 20, message = "犬主会员号长度必须介于 1 和 20 之间")
    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @Length(min = 1, max = 1, message = "是否可以上门配种标记位。0不可以；1可以长度必须介于 1 和 1 之间")
    public String getDoorToDoorFlag() {
        return doorToDoorFlag;
    }

    public void setDoorToDoorFlag(String doorToDoorFlag) {
        this.doorToDoorFlag = doorToDoorFlag;
    }

    @Length(min = 1, max = 20, message = "主标签，不可修改长度必须介于 1 和 20 之间")
    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Length(min = 1, max = 20, message = "其他标签，可修改长度必须介于 1 和 20 之间")
    public String getOtherLabel() {
        return otherLabel;
    }

    public void setOtherLabel(String otherLabel) {
        this.otherLabel = otherLabel;
    }

    @Length(min = 1, max = 300, message = "推荐信息长度必须介于 1 和 300 之间")
    public String getRecommendInfo() {
        return recommendInfo;
    }

    public void setRecommendInfo(String recommendInfo) {
        this.recommendInfo = recommendInfo;
    }

    @Length(min = 1, max = 64, message = "封面图片id长度必须介于 1 和 64 之间")
    public String getCoverImgId() {
        return coverImgId;
    }

    public void setCoverImgId(String coverImgId) {
        this.coverImgId = coverImgId;
    }

    @Length(min = 1, max = 350, message = "其他图片id，逗号分隔长度必须介于 1 和 350 之间")
    public String getOtherImgId() {
        return otherImgId;
    }

    public void setOtherImgId(String otherImgId) {
        this.otherImgId = otherImgId;
    }

    public String getDogNewbornCount() {
        return dogNewbornCount;
    }

    public void setDogNewbornCount(String dogNewbornCount) {
        this.dogNewbornCount = dogNewbornCount;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Date getBirthdate() {
        return birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getAge() {
        return age;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public String getDogPedigreeCertifiedChangeId() {
        return dogPedigreeCertifiedChangeId;
    }

    public void setDogPedigreeCertifiedChangeId(String dogPedigreeCertifiedChangeId) {
        this.dogPedigreeCertifiedChangeId = dogPedigreeCertifiedChangeId;
    }

    public String getViewCount() {
        return viewCount;
    }

    public void setViewCount(String viewCount) {
        this.viewCount = viewCount;
    }

    public String getViewCountFlag() {
        return viewCountFlag;
    }

    public void setViewCountFlag(String viewCountFlag) {
        this.viewCountFlag = viewCountFlag;
    }
}