package com.cku.oa.appreciation.web;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ListResultDto;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.appreciation.entity.AppreciationCourseware;
import com.cku.oa.appreciation.service.AppreciationCoursewareService;
import com.cku.oa.appreciation.vo.AppreciationCoursewareVo;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 鉴赏课Controller
 *
 * @author xx
 * @version 2022-02-17
 */
@Controller
@RequestMapping(value = "${adminPath}/appreciation/appreciationCourseware")
public class AppreciationCoursewareController extends BaseController {

	@Autowired
	private AppreciationCoursewareService appreciationCoursewareService;

	@ModelAttribute
	public AppreciationCourseware get(@RequestParam(required = false) String id) {
		AppreciationCourseware entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = appreciationCoursewareService.get(id);
		}
		if (entity == null) {
			entity = new AppreciationCourseware();
		}
		return entity;
	}

	@RequiresPermissions("appreciation:appreciationCourseware:view")
	@RequestMapping(value = {"list", ""})
	public String list(AppreciationCourseware appreciationCourseware, HttpServletRequest request,
					   HttpServletResponse response, Model model) {
		Page<AppreciationCourseware> page = appreciationCoursewareService
				.findPage(new Page<AppreciationCourseware>(request, response), appreciationCourseware);
		model.addAttribute("page", page);
		return "oa/appreciation/appreciationCourseware/appreciationCoursewareList";
	}

	@RequiresPermissions("appreciation:appreciationCourseware:edit")
	@RequestMapping(value = "editForm")
	public String editForm(AppreciationCourseware appreciationCourseware, Model model) {
		if(Objects.nonNull(appreciationCourseware) && StringUtils.isNotEmpty(appreciationCourseware.getId())) {
			model.addAttribute("appreciationCourseware", appreciationCourseware);
			return "oa/appreciation/appreciationCourseware/appreciationCoursewareEditForm";
		}
		return "oa/appreciation/appreciationCourseware/appreciationCoursewareAddForm";
	}

	@ResponseBody
	@RequestMapping(value = "save")
	public ResultDto<Boolean> save(@RequestBody List<AppreciationCourseware> appreciationCourseware) {
		ResultDto<Boolean> result = ResultDto.success(Boolean.TRUE);
		try {
			appreciationCoursewareService.addAllCourseware(appreciationCourseware);
			result.setMsg("保存课程资料成功");
		} catch (ZAException e) {
			ResultDto.error(ZAErrorCode.ZA_ERROR, "保存课程资料失败：" + e.getMessage());
		}
		return result;
	}

	@RequiresPermissions("appreciation:appreciationCourseware:del")
	@RequestMapping(value = "delete")
	public String delete(AppreciationCourseware appreciationCourseware, RedirectAttributes redirectAttributes) {
		try {
			appreciationCoursewareService.deleteCourseware(appreciationCourseware);
			addMessage(redirectAttributes, "删除课程资料成功");
		} catch (ZAException e) {
			addMessage(redirectAttributes, "删除课程资料失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/appreciation/appreciationCourseware/?repage";
	}

	@RequiresPermissions("appreciation:appreciationCourseware:onoff")
	@RequestMapping(value = "onoff")
	public String onoff(AppreciationCourseware appreciationCourseware, RedirectAttributes redirectAttributes) {
		try {
			appreciationCoursewareService.onoff(appreciationCourseware);
			addMessage(redirectAttributes, "上下架课程资料成功");
		} catch (ZAException e) {
			addMessage(redirectAttributes, "上下架课程资料失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/appreciation/appreciationCourseware/?repage";
	}


	@RequiresPermissions("appreciation:appreciationCourses:view")
	@GetMapping(value = "restList")
	@ResponseBody
	public ListResultDto<AppreciationCoursewareVo> restList(String id) {
		List<AppreciationCoursewareVo> voList;
		try {
			List<AppreciationCourseware> coursewareList = appreciationCoursewareService.findList(new AppreciationCourseware());
			voList = coursewareList.stream()
					.map(courseware -> {
						AppreciationCoursewareVo vo = new AppreciationCoursewareVo();
						BeanUtils.copyProperties(courseware, vo);
						return vo;
					})
					.collect(Collectors.toList());
			//设置选中项
			if (!StringUtils.isBlank(id)) {
				AppreciationCourseware search = new AppreciationCourseware();
				search.setCoursesId(id);
				List<AppreciationCourseware> checkedCoursewareList = appreciationCoursewareService.findList(search);
				if (!CollectionUtils.isEmpty(checkedCoursewareList)) {
					voList.forEach(vo -> vo.setChecked(checkedCoursewareList.stream()
							.anyMatch(checked -> vo.getId().equals(checked.getId()))));
				}
			}
		} catch (ZAException e) {
			return ListResultDto.error(ZAErrorCode.ZA_VALID_FAILED, e.getMessage());
		}
		return ListResultDto.success(voList);
	}

}