package com.cku.cab.editor.groomervenue.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.cab.editor.groomervenue.entity.GroomerVenue;
import com.cku.cab.editor.groomervenue.service.GroomerVenueService;
import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;

/**
 * 美容场馆Controller
 * @author zhuoHeng
 * @version 2016-11-25
 */
@Controller
@RequestMapping(value = "/api/v1/groomerVenue")
public class RestfulGroomerVenueController extends BaseController {

	@Autowired
	private GroomerVenueService groomerVenueService;
	
	
	/**
	 * 
	 * @Description：获取美容场馆信息
	 * @author: zhuoHeng
	 * @version: 2016年11月25日 下午6:10:35
	 */
	@RequestMapping(value = "/groomerVenue", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		RESTResponse result = groomerVenueService.getVenue(request);
		ServletUtils.writeResponse(response, result);
	}
	

}