//犬主变更添加页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.pedigreeCertifiedCode = ko.observable("");
        //根据血统证书号查出来的狗信息
        me.mydog = ko.observable({});
        //获取价格
        me.showPrice = ko.observable("0");
        //是否展开注意事项
        me.isOpen = ko.observable(false);
        me.isShow = function(){
            me.isOpen(!me.isOpen());
        }
        /**
         * 我的犬只列表根据血统证书号查询
         */
        me.getDog = function(){
            if(me.pedigreeCertifiedCode()){
                if(util.checkIsCKU(me.pedigreeCertifiedCode())==0){
                    layer.msg("非CKU开头的犬只不可以申请犬主变更！");
                    return;
                };
                var sendData = {};
                sendData["pedigreeCertifiedCode"] = me.pedigreeCertifiedCode();
                util.sendAjax({
                    url:'dog/dog/getOneByPedigreeCertified',
                    data:sendData,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            if(json.data!=null){
                                me.mydog(json.data);
                                var id = me.mydog().id;
                                me.getPrice(id);
                            }else{
                                layer.msg("查询信息失败，请输入正确的血统证书号！");
                                me.mydog({});
                                me.showPrice("0");
                            }
                        }else{
                            layer.msg("查询信息失败:"+json.msg);
                            me.mydog({});
                        }
                    }
                });
            }else{
                layer.msg("血统证书号不能为空！");
            }
        }
        //获取价格
        me.getPrice = function(id){
            var sendData = {};
            sendData["dogId"] = id;
            util.sendAjax({
                url:'dog/dogownerchange/getPrice',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.showPrice(json.data.price);
                    }else{
                        layer.msg("获取价格失败:"+json.msg);
                    }
                }
            });
        }
        /**
         * 保存
         */
        me.saveCart = function(){
            if(util.checkIsCKU(me.pedigreeCertifiedCode())==0){
                layer.msg("非CKU开头的犬只不可以申请犬主变更！");
                return;
            };
            var sendData = {};
            sendData["dogId"] = me.mydog().id;
            util.sendAjax({
                url:'dog/dogownerchange',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc ==0){
                        context.app.changeCart();
                        layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                    }else{
                        layer.msg("犬主变更申请失败:"+json.msg);
                    }
                }
            });
        }
        context.app.loading(false);
        context.app.isShop(false);
    }
});