//证书焕发列表页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //外国血统证书号
        me.overseasPedigreeCertified = ko.observable("");
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.finddogpedigreecertifiedchangeList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }
            me.finddogpedigreecertifiedchangeList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.finddogpedigreecertifiedchangeList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.finddogpedigreecertifiedchangeList(false);
            }
            return false;
        }
        //未通过原因的显隐
        me.showReason = function(data,event){
            if(data.businessState=="未通过"||data.businessState=="已通过") {
                if ($(event.target).parent("a").siblings(".reason").css("display") == "none") {
                    $(event.target).parent("a").siblings(".reason").css("display", "block");
                } else {
                    $(event.target).parent("a").siblings(".reason").css("display", "none");
                }
            }
        }
        me.closeReason = function(data,event){
            $(event.target).parents(".reason").css("display","none")
        }
        /**
         * 证书焕发列表查询方法
         */
        me.finddogpedigreecertifiedchangeList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["overseasPedigreeCertified"] = me.overseasPedigreeCertified().trim();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'dog/dogpedigreecertifiedchange',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData.removeAll();
                            for(var i=0;i<data.list.length;i++){
                                var temp = data.list[i];
                                if(temp.businessState=="未通过" || (temp.businessState=="已通过" && temp.isCanCancel=="1")){
                                    temp["cexiao"] = true;
                                }else{
                                    temp["cexiao"] = false;
                                }
                                me.listData.push(temp);
                            }
                        }else{
                            me.listData([]);
                            layer.msg("证书换发列表为空！");
                        }

                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        me.showState = function(data,event){
            console.log(data);
            return false;
        }

        /**
         * 证书焕发撤销
         */
        me.changeRemove = function(data,event){
            if(data.processState=='撤销') {
                //询问框
                var changeRemovelayer = layer.confirm('申请撤销后退款会在一个月内退至会员中心账户，是否确认撤销？', {
                    btn: ['确定','关闭'] //按钮
                }, function(){
                    var id = data.id;
                    util.sendAjax({
                        url: 'dog/dogpedigreecertifiedchange/canceled/' + id,
                        data: {},
                        async:true,
                        loadFlag:true,
                        type: 'DELETE',
                        cache: false,
                        success: function (data) {
                            if (data.rc == 0) {
                                layer.close(changeRemovelayer);
                                layer.msg("证书换发撤销成功！");
                                me.finddogpedigreecertifiedchangeList(false);
                            }else{
                                layer.msg("证书换发撤销失败:"+data.msg);
                            }
                        }
                    });
                });
            }
        }
        $(function(){
            me.finddogpedigreecertifiedchangeList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});