<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>赛事报名表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			$("#btnExport").click(function(){
				$.jBox($("#importBox").html(), {title:"赛事导出", buttons:{"关闭":true},
					bottomText:"只有赛事报名已截止后才能导出数据"});
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function setExportParam(){
			console.log($(":input[name='showCodePrefix']").get(1).value);
			var showCodePrefix = $(":input[name='showCodePrefix']").get(1).value;
			if(showCodePrefix.length<6){
				$("a[name='exportURL']:eq(1)").attr('href','#');
				return;
			}
			var exportURL = "${ctx}/apply/showApply/export?showCodePrefix=";
			$("a[name='exportURL']:eq(1)").attr('href',exportURL+showCodePrefix);
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
<div id="importBox" class="hide">
	<form id="importForm" class="form-search" style="padding-left:20px;text-align:center;"><br/>
		<label>请输入需要导出的6位赛事编号</label>
		<input name="showCodePrefix" type="text" onblur="setExportParam()" style="width:100px"/><br/><br/>
		<a name="exportURL" href="#">导出</a>
	</form>
</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/showApply/">赛事报名表列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="showApply" action="${ctxDc}/showApply/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>报名序号：</label>
				<form:input path="applyCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>证书/芯片：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬主人/会员号：</label>
				<form:input path="dogOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>备注：</label>
				<form:input path="remarks" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>缴费：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>过期：</label>
				<form:select path="expireFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="未过期"/>
					<form:option value="1" label="已过期"/>
				</form:select>
			</li>
			<li><label>删除：</label>
				<form:select path="delFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('del_flag')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${showApply.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${showApply.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<%--<li class="btns"><input id="btnExport" class="btn btn-primary" type="button" value="导出赛事报名信息"/></li>--%>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>犬主人</th>
				<th>会员号</th>
				<th>备注</th>
				<th>犬种</th>
				<th width="15%">犬名</th>
				<th>出生日期</th>
			<%--	<th>年龄组别</th>
				<th>BBE</th>--%>
				<th>血统证书号</th>
				<th>芯片号</th>
				<th>赛事编号</th>
				<th>余额</th>
				<th>报名费</th>
				<th>实收金额</th>
				<th>缴费</th>
				<th>提交时间</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showApply">
			<tr>
				<td>
					${fns:escapeHtml(showApply.applyCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogOwnerNameCn)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogOwnerMemberCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.remarks)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogBreedNameCn)}
				</td>
				<td title="${fns:escapeHtml(showApply.dogName)}">
					<%--${fns:abbr(showApply.dogName,20)}--%>
                    ${fns:escapeHtml(showApply.dogName)}
				</td>
				<td>
					<fmt:formatDate value="${showApply.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
<%--				<td>
					${fns:getDictLabel(showApply.ageGroup, 'show_age_group', '')}
				</td>
				<td>
					${fns:getDictLabel(showApply.bbeFlag, 'show_apply_bbe', '')}
				</td>--%>
				<td>
					${fns:escapeHtml(showApply.pedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(showApply.chipCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.showCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.accountBalance)}
				</td>
				<td>
					${fns:escapeHtml(showApply.fee)}
				</td>
				<td>
					${fns:escapeHtml(showApply.paymentAmount)}
				</td>
				<td>
					<c:choose>
						<c:when test="${showApply.paymentState=='1'}">
							未缴费
						</c:when>
						<c:otherwise>
							已缴费
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<fmt:formatDate value="${showApply.createDate}" pattern="yyyy/MM/dd HH:mm"/>
				</td>
				<td>
					<a href="${ctxDc}/showApply/form?id=${showApply.id}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>