<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>宠集盒上架管理</title>
    <meta name="decorator" content="default"/>
    <link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet"/>
    <script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
    <script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
    <link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
    <link href="${ctxStatic}/cropper/cropper.min.css" rel="stylesheet"/>
    <script src="${ctxStatic}/cropper/Cropper3.1.3.min.js"></script>
    <script src="${ctxStatic}/cropper/canvas-to-blob.js"></script>
    <style>
        .defaultButton {
            margin-top: 24px;
            display: inline-block;
            width: 137px;
            height: 40px;
            border-radius: 8px;
            overflow: hidden;
            font-size: 14px;
            color: #fff;
            text-align: center;
            line-height: 40px;
            background-repeat: no-repeat;
            /*background-image: url("scripts/templates/dog/image/buttonDefault.png");*/
            background: rgb(43, 174, 117);

        }

        .defaultButton:hover, .operationback:hover {
            background: rgb(50, 196, 135);
        }

        .imginput {
            width: 0 !important;
            height: 0 !important;
            overflow: hidden
        }

        .defaultButton:active, .operationback:active {
            background: rgb(50, 196, 135);
            border: none;
        }

        .container-layer {
            width: 600px;
            height: 400px;
        }

        #photo {
            max-width: 400px;
            max-height: 300px;
            width: 400px;
            height: 300px;
        }

        .img-preview {
            width: 100px;
            height: 100px;
            overflow: hidden;
        }

        #test1 {
            width: 180px;
            height: 180px;
        }

        #test2 {
            width: 180px;
            height: 180px;
        }

        #test3 {
            width: 180px;
            height: 180px;
        }

        .imghidden {
            display: none;
        }

        .grayColor {
            background-color: rgb(198, 198, 198) !important;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });

    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctxPartner}/fsbDogGrounding/">宠集盒上架列表</a></li>
    <li class="active"><a
            href="${ctxPartner}/fsbDogGrounding/form?id=${fsbDogGrounding.id}">宠集盒上架${not empty fsbDogGrounding.id?'修改':'添加'}</a>
    </li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="fsbDogGrounding" action="${ctxPartner}/fsbDogGrounding/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <form:hidden path="appraisalId"/>
    <sys:message content="${message}"/>

    <div class="control-group">
        <ul class="ul-form">
            <label class="control-label">芯片号：</label>
            <div class="controls">
                <input id="identificationFlag" htmlEscape="false" maxlength="40" class="input-xlarge "/>
            </div>
        </ul>
    </div>
    <div class="control-group">
        <input class="btn btn-primary" onclick="searchIdentificationFlag()" value="查询"/>
    </div>
    <div class="control-group">
        <label class="control-label">级别：</label>
        <div id="partnerLevel" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物类型：</label>
        <div id="petType" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物姓名：</label>
        <div id="petName" class="controls">

        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物性别：</label>
        <div id="dogGender" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">出生日期：</label>
        <div id="petBirthdate" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物毛色：</label>
        <div id="petColor" class="controls">
        </div>

    </div>
    <div class="control-group">
        <label class="control-label">宠主手机号：</label>
        <div id="petOwnerMobile" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">鉴定结果：</label>
        <div id="appraisalResult" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">鉴定人：</label>
        <div id="appraisal" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">鉴定时间：</label>
        <div id="appraisalDate" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠爱护照：</label>
        <div id="passport" class="controls">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">正面照：</label>
        <div><img id="test1" width="180px" height="180px" class="imghidden" src=""></div>
    </div>
    <div class="control-group">
        <label class="control-label">侧面照：</label>
        <div><img id="test2" width="180px" height="180px" class="imghidden" src=""></div>
    </div>
    <div class="control-group">
        <label class="control-label">背面照：</label>
        <div><img id="test3" width="180px" height="180px" class="imghidden" src=""></div>

    </div>
    <div class="control-group">
        <label class="control-label">报价：</label>
        <div class="controls">
            <form:input path="price" htmlEscape="false" maxlength="8" class="input-xlarge "/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬只所在城市：</label>
        <div class="controls">
            <form:select path="city" class="input-xlarge ">
                <form:option value="" label=""/>
                <c:forEach items="${postalcity}" var="p">
                    <form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
                </c:forEach>
            </form:select>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">电话：</label>
        <div class="controls">
            <form:input path="mobile" htmlEscape="false" maxlength="20" class="input-xlarge "/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">联系人：</label>
        <div class="controls">
            <form:input path="linkman" htmlEscape="false" maxlength="40" class="input-xlarge "/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">生活照片：</label>
        <div class="controls">
            <div><img id="test4" class="imghidden" src="" style="width:180px;height: 180px;"></div>
            <div style="margin-left: 100px;">
                <label class="defaultButton" id="frontViewlabel">
                    生活照片上传
                    <input type="file" class="imginput sr-only" id="frontView"
                           onchange="fileChange(event)"
                           accept="image/jpeg,image/png,image/jpg"/>
                </label>
            </div>
        </div>
        <form:input id="lifePic" path="lifePic" htmlEscape="false" class="input-xlarge " type="hidden"/>
    </div>
    <div class="control-group">
        <label class="control-label">生活照片：</label>
        <div class="controls">
            <div><img id="test5" class="imghidden" src="" style="width:180px;height: 180px;"></div>
            <div style="margin-left: 100px;">
                <label class="defaultButton" id="frontViewlabel5">
                    生活照片上传
                    <input type="file" class="imginput sr-only" id="frontView5"
                           onchange="fileChange(event)"
                           accept="image/jpeg,image/png,image/jpg"/>
                </label>
            </div>
        </div>
        <form:input id="lifePic5" path="lifePic5" htmlEscape="false" class="input-xlarge " type="hidden"/>
    </div>
    <div class="control-group">
        <label class="control-label">生活照片：</label>
        <div class="controls">
            <div><img id="test6" class="imghidden" src="" style="width:180px;height: 180px;"></div>
            <div style="margin-left: 100px;">
                <label class="defaultButton" id="frontViewlabel6">
                    生活照片上传
                    <input type="file" class="imginput sr-only" id="frontView6"
                           onchange="fileChange(event)"
                           accept="image/jpeg,image/png,image/jpg"/>
                </label>
            </div>
        </div>
        <form:input id="lifePic6" path="lifePic6" htmlEscape="false" class="input-xlarge " type="hidden"/>
    </div>
    <div class="control-group">
        <label class="control-label">生活照片：</label>
        <div class="controls">
            <div><img id="test7" class="imghidden" src="" style="width:180px;height: 180px;"></div>
            <div style="margin-left: 100px;">
                <label class="defaultButton" id="frontViewlabel7">
                    生活照片上传
                    <input type="file" class="imginput sr-only" id="frontView7"
                           onchange="fileChange(event)"
                           accept="image/jpeg,image/png,image/jpg"/>
                </label>
            </div>
        </div>
        <form:input id="lifePic7" path="lifePic7" htmlEscape="false" class="input-xlarge " type="hidden"/>
    </div>
    <div class="control-group">
        <label class="control-label">生活照片：</label>
        <div class="controls">
            <div><img id="test8" class="imghidden" src="" style="width:180px;height: 180px;"></div>
            <div style="margin-left: 100px;">
                <label class="defaultButton" id="frontViewlabel8" style="z-index:auto">
                    生活照片上传
                    <input type="file" class="imginput sr-only" id="frontView8"
                           onchange="fileChange(event)"
                           accept="image/jpeg,image/png,image/jpg"/>
                </label>
            </div>
        </div>
        <form:input id="lifePic8" path="lifePic8" htmlEscape="false" class="input-xlarge " type="hidden"/>
    </div>
    <div class="control-group">
        <label class="control-label">是否寄售：</label>
        <input id="consigns" name="consigns" value="0" type="checkbox"/>
        <label for="consigns"> 此犬可寄售（寄售具体条款请与宠物店提前协商）</label>
        <form:input path="consign" htmlEscape="false" class="input-xlarge " type="hidden"/>
    </div>
    <div class="form-actions">
        <c:if test="${fsbDogGrounding.operation=='2'}">
            <input id="btnSubmit" class="btn btn-primary" onclick="submit1()" type="button" value="保 存"/>
        </c:if>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
<div style="height: 0;overflow: hidden">
    <div class="container container-layer" style="width: 580px;    padding-top: 50px;">
        <div>
            <div style="width: 300px;height: 300px;display: inline-block">
                <img src="" id="photo">
            </div>
            <div class="img-preview-area"
                 style="width: 180px;display: inline-block;margin-left: 50px;vertical-align: top;">
                <div>
                    <p>
                        预览：
                    </p>
                    <div class="img-preview" style="width: 140px;height:120px;margin-top: 15px;">
                    </div>
                </div>
                <button class="cropUpload defaultButton" onclick="crop()"
                        style="border: none;margin-top: 110px;width: 160px">确认裁剪并上传
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    //    $(function () {
    //        $('#consign').click(function () {
    //            if ($('input[name="consign"]').prop("checked"))
    //                $("#consign").val("1")
    //            else
    //                $("#consign").val("0");
    //
    //        });
    //    });
    function showDate(jsons) {
        if (jsons != null) {
            if (jsons.rc != 0) {
                alertx(jsons.msg);
                $("#identificationFlag").val("");
                $("#partnerLevel").text("");
                $("#petType").text("");
                $("#petName").text("");
                $("#dogGender").text("");
                $("#petBirthdate").text("");
                $("#petColor").text("");
                $("#petOwnerMobile").text("");
                $("#appraisalResult").text("");
                $("#appraisal").text("");
                $("#appraisalDate").text("");
                $("#passport").text("");
                $("#test1").addClass("imghidden");
                $("#test2").addClass("imghidden");
                $("#test3").addClass("imghidden");
            } else {
                $("#partnerLevel").text("伴侣级");
                $("#identificationFlag").val(jsons.identificationFlag);
                $("#petType").text(jsons.petType == '0' ? '狗' : '猫');
                $("#petName").text(jsons.petName);
                $("#dogGender").text(jsons.dogGender == '1' ? '公' : '母');
                $("#petBirthdate").text(jsons.petBirthdate);
                $("#petColor").text(jsons.petColor);
                $("#petOwnerMobile").text(jsons.petOwnerMobile);
                $("#appraisalResult").text("通过");
                $("#appraisal").text(jsons.appraisal);
                $("#appraisalDate").text(jsons.appraisalDate);
                $("#passport").text(jsons.passportNo);
                $("#test1").attr("src", "${pageContext.request.contextPath}/api/v1/open/image/" + jsons.frontPic).removeClass('imghidden');
                $("#test2").attr("src", "${pageContext.request.contextPath}/api/v1/open/image/" + jsons.sidePic).removeClass('imghidden');
                $("#test3").attr("src", "${pageContext.request.contextPath}/api/v1/open/image/" + jsons.backPic).removeClass('imghidden');
                $("#appraisalId").val(jsons.id);
            }
        } else {
            alertx("数据不存在");
            $("#partnerLevel").text("");
            $("#petType").text("");
            $("#petName").text("");
            $("#dogGender").text("");
            $("#petBirthdate").text("");
            $("#petColor").text("");
            $("#petOwnerMobile").text("");
            $("#appraisalResult").text("");
            $("#appraisal").text("");
            $("#appraisalDate").text("");
            $("#passport").text("");
            $("#test1").attr("class", "imghidden");
            $("#test2").attr("class", "imghidden");
            $("#test3").attr("class", "imghidden");

        }
    }
    if ($("#appraisalId").val() != '') searchId();
    //根据id 查找伴侣犬数据
    function searchId() {
        var appraisalId = $("#appraisalId").val();
        $.ajax({
            type: "GET",
            url: "${ctxPartner}/companionDogAppraisal/getByIdentificationFlag?id=" + appraisalId,
            dataType: 'json',
            async: false,
            success: showDate
        });
    }//根据芯片号 查找伴侣犬数据
    function searchIdentificationFlag() {
        var identificationFlag = $("#identificationFlag").val();
        if (identificationFlag == '' || identificationFlag == null) {
            alertx("芯片号不能为空");
            return;
        }
        $.ajax({
            type: "GET",
            url: "${ctxPartner}/companionDogAppraisal/getByIdentificationFlag?identificationFlag=" + identificationFlag,
            dataType: 'json',
            async: false,
            success: showDate
        });
    }
    <!-- 文件上传成功的回调方法 -->
    $(document).ready(function () {
        initCropper($('#photo'), $('#lifePic'));
    });
    var containerLayer, imgTargetNum, fileChange;
    //截图初始化方法
    var initCropper = function (img, input) {
        var $image = img;
        var options = {
            aspectRatio: 1, // 纵横比
            viewMode: 0,
            dragMode: 'none',
            cropBoxResizable: true,
            responsive: false,
            minCanvasHeight: 300,
            minCanvasWidth: 300,
            autoCropArea: 1,
            //background:true,
            preview: '.img-preview' // 预览图的class名
        };
        $image.cropper(options);
        var $inputImage = input;
        var uploadedImageURL;
        if (URL) {
            // 给input添加监听
            fileChange = function (event) {
                var event = event || window.event || arguments[0];
                //target 就是这个对象
                target = event.srcElement || event.target;
                imgTargetNum = target.id;
                //捕获页
                containerLayer = layer.open({
                    type: 1,
                    shade: false,
                    title: "裁剪图片", //不显示标题
                    content: $('.container-layer'), //捕获的元素，注意：最好该指定的元素要存放在body最外层，否则可能被其它的相对元素所影响
                    area: ['700px', '450px'], //宽高
                    // cancel: function(){
                    //     layer.msg('捕获就是从页面已经存在的元素上，包裹layer的结构', {time: 5000, icon:6});
                    // }
                });

                var files = target.files;
                var file;
                if (!$image.data('cropper')) {
                    return;
                }
                if (files && files.length) {
                    file = files[0];
                    // 判断是否是图像文件
                    if (/^image\/\w+$/.test(file.type)) {
                        // 如果URL已存在就先释放
                        if (uploadedImageURL) {
                            URL.revokeObjectURL(uploadedImageURL);
                        }
                        uploadedImageURL = URL.createObjectURL(file);
                        // 销毁cropper后更改src属性再重新创建cropper
                        $image.cropper('destroy').attr('src', uploadedImageURL).cropper(options);
                        $(event.target).val('');
                    } else {
                        window.alert('请选择一个图像文件！');
                    }
                }
            }
        } else {
            $inputImage.prop('disabled', true).addClass('disabled');
        }
    }
    //截图
    var crop = function (item, event) {
        layer.close(containerLayer);

        var $image = $('#photo');
        $image.cropper('getCroppedCanvas', {
            width: 1600, // 裁剪后的长宽
            height: 1600
        }).toBlob(function (blob) {
            console.log(blob);
            layer.load();
            var formData = new FormData();
            formData.append('file', blob);
            //formData.append('module', 'pupImg');
            $.ajax({
                url: '${ctxPartner}/dogActivation/layupload',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                cache: false,
                success: function (json) {
                    var json = JSON.parse(json);
                    if (imgTargetNum == 'frontView') {
                        $("#test4").attr("src", json.url).removeClass('imghidden');
                        $("#lifePic").val(json.id);
                    }
                    if (imgTargetNum == 'frontView5') {
                        $("#test5").attr("src", json.url).removeClass('imghidden');
                        $("#lifePic5").val(json.id);
                    }
                    if (imgTargetNum == 'frontView6') {
                        $("#test6").attr("src", json.url).removeClass('imghidden');
                        $("#lifePic6").val(json.id);
                    }
                    if (imgTargetNum == 'frontView7') {
                        $("#test7").attr("src", json.url).removeClass('imghidden');
                        $("#lifePic7").val(json.id);
                    }
                    if (imgTargetNum == 'frontView8') {
                        $("#test8").attr("src", json.url).removeClass('imghidden');
                        $("#lifePic8").val(json.id);
                    }
                },
                error: function (XMLHttpRequest, status, error) {
                    layer.msg('网络连接错误！', {icon: 5});
                },
                complete: function (XMLHttpRequest, TS) {
                    layer.closeAll('loading');
                }
            });
        }, "image/jpeg", 0.95);
    }
    if ($("#lifePic").val() != '') {
        $("#test4").attr("src", "${pageContext.request.contextPath}/api/v1/open/image/" + $("#lifePic").val()).removeClass('imghidden');
    }

    if ($("#lifePic5").val() != '') {
        $("#test5").attr("src", "${pageContext.request.contextPath}/api/v1/open/image/" + $("#lifePic5").val()).removeClass('imghidden');
    }

    if ($("#lifePic6").val() != '') {
        $("#test6").attr("src", "${pageContext.request.contextPath}/api/v1/open/image/" + $("#lifePic6").val()).removeClass('imghidden');
    }

    if ($("#lifePic7").val() != '') {
        $("#test7").attr("src", "${pageContext.request.contextPath}/api/v1/open/image/" + $("#lifePic7").val()).removeClass('imghidden');
    }

    if ($("#lifePic8").val() != '') {
        $("#test8").attr("src", "${pageContext.request.contextPath}/api/v1/open/image/" + $("#lifePic8").val()).removeClass('imghidden');
    }

    if ($("#consign").val() == '1')
        $("#consigns").prop('checked', true);

    function submit1() {

        if ($("#appraisalId").val() == "") {
            alert("请查处芯片号对应的信息");
            return false;
        }
        if ($('input[name="consigns"]').prop("checked")) {
            $("#consign").val("1")
        } else {
            $("#consign").val("0")
        }
        if ($("#mobile").val() == "") {
            alert("手机号不能为空");
            return false;
        } else {
            if (!(/^[1][0-9]{10}$/.test($("#mobile").val()))) {
                alert("不是完整的11位手机号或者正确的手机号前七位");
                return false;
            }
        }
        if ($("#linkman").val() == "") {
            alert("联系人不能为空");
            return false;
        }
        if ($("#price").val() == "") {
            alert("价格不能为空");
            return false;
        } else {
            var reg = /^(0|[1-9][0-9]*)$/;
            if (!reg.test($("#price").val())) {
                alert("请输入正确的金额")
                return false;
            }
        }
        $("#inputForm").submit();
    }

</script>
</body>
</html>