<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>视频鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});

		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }

	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxPartner}/dogvideoappraisal/list">视频鉴定列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogVideoAppraisal" action="${ctxPartner}/dogvideoappraisal/list" method="get" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<input id="id" name="ia"  type="hidden"  />

		<ul class="ul-form">
			<li><label>会员姓名/会员号:</label>
				<form:input path="memberInfo" placeholder="会员姓名/会员号"  htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬名</th>
				<th>品种</th>
				<th>犬主</th>
				<th>芯片编号</th>
				<th>护照编号</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>宠爱护照打印</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogVideoAppraisal">
			<tr>
				<td>
					${fns:escapeHtml(dogVideoAppraisal.dogName)}
				</td>
				<td title="${fns:escapeHtml(dogVideoAppraisal.dogBreedCn)}">
					${fns:escapeHtml(dogVideoAppraisal.dogBreed)}
				</td>
				<td title="${fns:escapeHtml(dogVideoAppraisal.memberCode)}">
					${fns:escapeHtml(dogVideoAppraisal.memberName)}
				</td>
				<td>
					${fns:escapeHtml(dogVideoAppraisal.chipNo)}
				</td>
				<td>
					${fns:escapeHtml(dogVideoAppraisal.passportNo)}
				</td>
				<td>
					<fmt:formatDate value="${dogVideoAppraisal.dogBirth}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogVideoAppraisal.createDate}" pattern="yyyy-MM-dd"/>
				</td>

				<td style="color:${dogVideoAppraisal.paymentState eq '2' ? '#090' : '#F00'}">
					${fns:getDictLabel(dogVideoAppraisal.paymentState, 'user_payment_state', '')}
				</td>
				<c:choose>
					<c:when test="${dogVideoAppraisal.paymentState eq '2'}">
						<td style="color:${dogVideoAppraisal.reviewState eq '1' ? '#090' :'#F00'}">
							${fns:getDictLabel(dogVideoAppraisal.reviewState, 'dog_appraisal_review_state', '')}
						</td>
					</c:when>
					<c:otherwise>
						<td></td>
					</c:otherwise>
				</c:choose>
				
				<td>
				<c:if test="${not empty dogVideoAppraisal.chipNo && dogVideoAppraisal.reviewState ne '0' && dogVideoAppraisal.resolveStatus eq '1'}">
					<c:if test="${dogVideoAppraisal.printStatus eq '0' }">
						<a href="${ctxPartner}/dogvideoappraisal/print?id=${dogVideoAppraisal.id}">打印</a>
					</c:if>
					<c:if test="${dogVideoAppraisal.printStatus eq '1' }">
						已打印	
					</c:if>
				</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>