<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出生证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxPartner}/clubMember/dogList">已缴费</a></li>
		<li><a href="${ctxPartner}/clubMember/dogOldList">未缴费</a></li>
		<li class="active"><a href="${ctxPartner}/clubMember/dogChipInjectList">芯片代打未缴费</a></li>
		<li><a href="${ctxPartner}/clubMember/dogAllNestList">整窝办理</a></li>

	</ul>
	<form:form id="searchForm" modelAttribute="paymentOrder" action="${ctxPartner}/clubMember/dogChipInjectList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>登记卡编号：</label>
				<form:input path="remark" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><font style="color:red;font-size:18px;">特别提醒:办理业务请于当天24点前缴费!</font></li>
			<li class="clearfix"></li>
		</ul>
		<%--<ul class="ul-form">--%>
			<%--<li><label>申请时间：</label>--%>
				<%--<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"--%>
					<%--value="<fmt:formatDate value="${paymentOrder.beginCreateDate}" pattern="yyyy-MM-dd"/>"--%>
					<%--onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> ---%>
				<%--<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"--%>
					<%--value="<fmt:formatDate value="${paymentOrder.endCreateDate}" pattern="yyyy-MM-dd"/>"--%>
					<%--onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>--%>
			<%--</li>--%>
			<%----%>
		<%--</ul>--%>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>登记卡编号</th>
				<th>新犬主</th>
				<th>申请日期</th>
				<th>缴费</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentOrder">
			<tr>
				<td>
					${paymentOrder.remark}
				</td>
				<td title="${paymentOrder.memberCode}">
						${paymentOrder.memberName}
				</td>
				<td>
					<fmt:formatDate value="${paymentOrder.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
    			<td>
					<a style="color:red;" href="${ctxPartner}/clubMember/paymentDogChipInject?orderId=${paymentOrder.id}&memberCode=${paymentOrder.memberCode}">办理缴费</a>
    			</td>
    			<td>
					<a style="color:red;" href="${ctxPartner}/clubMember/delDogChipInject?orderId=${paymentOrder.id}">删除</a>
    			</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>