<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>地方俱乐部信息统计</title>
<meta name="decorator" content="default" />

<script type="text/javascript">
	$(document).ready(function() {
		$("#btnExport").click(function(){
			top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					$("#searchForm").attr("action","${ctx}/sys/org/exportIncome");
					$("#searchForm").submit();
					$("#searchForm").attr("action","${ctx}/sys/org/income?orgType=chongjihemendian");
				}
			},{buttonsFocus:1});
			top.$('.jbox-body .jbox-icon').css('top','55px');
		});
	});
	function page(n, s) {
		$("#pageNo").val(n);
		$("#pageSize").val(s);
		$("#searchForm").submit();
		return false;
	}
	function SubmitByDate(date) {
		document.getElementById("nowDate").value = date
		document.getElementById("searchForm").submit();
	}
</script>
<style>
th, td {
	text-align: center !important;
	vertical-align: middle !important;
}
</style>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class=""><a href="${ctx}/sys/org/income?orgType=club">俱乐部</a></li>
		<li class=""><a href="${ctx}/sys/org/income?orgType=hospital">合作医院</a></li>
		<li class=""><a href="${ctx}/sys/org/income?orgType=catRenZheng">认证中心</a></li>
		<li class="active"><a href="">鉴定门店</a></li>
	</ul>
	<form id="searchForm" action="${ctx}/sys/org/income" method="post" class="breadcrumb form-search">
		<ul class="ul-form">
			<li>
				<label>机构名称：</label> <input id="name" name="name" type="text" maxlength="20" class="input " style="width: 163px" 	value="${name}" />
			</li>
			<li>
				<label>机构编号：</label> <input id="memberCode" name="memberCode" type="text" maxlength="20" class="input " style="width: 163px" 	value="${memberCode}" />
			</li>
			<li>
				<label>所属机构：</label>
				<select id="tuijiansren" name="tuijiansren" class="input-small selector" style="width: 177px">
					<option value="">请选择</option>
					<c:forEach items="${orgList}" var="p">
						<option value="${fns:escapeHtml(p.id) }"
								<c:if test="${p.id eq tuijiansren }">
									selected = "selected"
								</c:if>>${fns:escapeHtml(p.name) }
						</option>
					</c:forEach>
				</select>
			</li>
			<li><label>开始时间：</label> <input id="startDate" name="startDate"
				type="text" readonly="readonly" maxlength="20"
				class="input-medium Wdate" value="${startDate}"
				onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>

			<li><label>结束时间：</label> <input id="endDate" name="endDate"
				type="text" readonly="readonly" maxlength="20"
				class="input-medium Wdate" value="${endDate}"
				onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>
			<li style="padding-left: 72px" class="btns">
				<input id="btnSubmit" class="btn btn-primary" onclick="SubmitByDate('input')" type="submit" value="查询" />
			</li>
			<li class="btns"><input id="btnExport" class="btn btn-primary" type="button" value="导出查询结果"/></li>
			<li><input id="nowDate" type="hidden" name="nowDate" value="" /></li>
			<li><input id="orgType" type="hidden" name="orgType" value="chongjihemendian" /></li>

		</ul>

	</form>
	<sys:message content="${message}" />
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
		<tr>
			<th rowspan="3">地区</th>
			<th rowspan="3">机构名称</th>
			<th rowspan="3">机构编号</th>
			<th rowspan="3">所属机构</th>
			<th >会员业务</th>
			<th colspan="2">繁殖业务</th>
		</tr>
		<tr>
			<th >普卡会员</th>
			<th colspan="2">线上鉴定</th>
		</tr>
		<%--<tr>--%>
			<%--<th>数量</th>--%>
			<%--<th>数量</th>--%>
			<%--&lt;%&ndash;<th>金额</th>&ndash;%&gt;--%>
		<%--</tr>--%>
		</thead>
		<tbody id="clubContent">
		<c:forEach items="${results}" var="result">
			<tr>
				<td>${result.area_name}</td>
				<td>${result.name}</td>
				<td>${result.member_code}</td>
				<td>${result.tuijiansren}</td>
				<td><font color="blue">${result.defult_card_count}</font></td>
				<td><font color="blue">${result.video_count}</font></td>
				<%--<td><font color="brown">${result.video_price}</font>--%>
			</tr>

		</c:forEach>
		</tbody>
	</table>
</body>
</html>