<%@ page import="java.util.Calendar" %>
<%@ page import="com.cku.oa.sys.entity.ExpressSend" %>
<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	
	<title>邮寄发件管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/expressSend/">邮寄记录</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="expressSend" action="${ctx}/sys/expressSend/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li><label>会员姓名：</label>
				<form:input path="memberName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>发件内容：</label>
				<form:input path="content" htmlEscape="false" class="input-medium"/>
			</li>
			<li><label>发件备注：</label>
				<form:input path="sendRemarks" htmlEscape="false" class="input-medium"/>
			</li>
			<li><label>邮寄日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${expressSend.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${expressSend.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="sys:expressSend:add">
			<li class="btns" style="float:right" onclick=""><input  class="btn btn-primary" type="submit" value="邮寄申请" onclick="searchQueue();return false;"/></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>会员姓名</th>
				<th>发件内容</th>
				<th>发件备注</th>
				<th>类型</th>
				<th>快递名</th>
				<!-- TODO zhaoxy -->
			    <th>承运单号</th>
			    <th>电子单据</th>
				<th>邮寄日期</th>
				<th>操作</th>
				<shiro:hasPermission name="sys:expressSend:print"><th>打印</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="expressSend">
			<tr>
				<td>
					${expressSend.memberCode}
				</td>
				<td>
					${expressSend.memberName}
				</td>
				<td>
					${expressSend.content}
				</td>
				<td>
					${expressSend.remarks }
				</td>
				<td>
					<c:choose>
						<c:when test="${expressSend.expressType=='1'}">
							<font>到付快递</font>
						</c:when>
						<c:when test="${expressSend.expressType=='2'}">
							<font>月付快递-cku付费</font>
						</c:when>
						<c:when test="${expressSend.expressType=='3'}">
							<font>挂号信</font>
						</c:when>
						<c:when test="${expressSend.expressType=='4'}">
							<font>自取</font>
						</c:when>
						<c:otherwise>
							${expressSend.expressType}
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					${fns:getDictLabel(expressSend.expressName,'express_name','')}
				</td>
				<!-- TODO zhaoxy --> 
				<td>
					<c:choose>
						<c:when test="${empty  expressSend.otherExpressNo}">
							${expressSend.expressNo}
						</c:when>
						<c:otherwise>
							<a javascript:void(0);" onclick="searchSFRoute('${expressSend.expressNo}')" style="font-weight: bold;">  ${expressSend.otherExpressNo} </a> 
						</c:otherwise>
					</c:choose>
				</td>  
				
				
				 <td>
				 	<c:choose>
						<c:when test="${empty  expressSend.otherExpressNo}">
							
						</c:when>
						<c:otherwise>
							<a javascript:void(0);" onclick="reviewSfBill('${expressSend.id}')" style="font-weight: bold;"> 预览 </a>
						</c:otherwise>
					</c:choose>
				 </td>
				
				<td>
					<fmt:formatDate value="${expressSend.postDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>

				<td>
					<shiro:hasPermission name="sys:expressSend:edit">
				    <!-- TODO zhaoxy -->
    				 <%-- <c:if test="${not empty expressSend.otherExpressNo }">  --%>
    					<a href="${ctx}/sys/expressSend/editForm?id=${expressSend.id}">修改</a>
    				<%--  </c:if> 
    				 <c:if test="${empty expressSend.otherExpressNo }"> 
    					<a href="${ctx}/sys/expressSend/editForm?id=${expressSend.id}">修改</a>
    				 </c:if>  --%>
    				</shiro:hasPermission>
    				<shiro:hasPermission name="sys:expressSend:delete">
					<a href="${ctx}/sys/expressSend/delete?id=${expressSend.id}" onclick="return confirmx('确认要删除该邮寄发件吗？', this.href)">删除</a></shiro:hasPermission>
				</td>
				<td>
					<%
						// 获取当前日期
						Calendar now = Calendar.getInstance();

						// 创建一个日期，比如当前日期加一周
						ExpressSend expressSend = (ExpressSend) pageContext.getAttribute("expressSend");
						Calendar nextWeek = Calendar.getInstance();
						nextWeek.setTime(expressSend.getPostDate());
						nextWeek.add(Calendar.DATE, 7); // 加一周，即加7天

						// 判断是否大于当前日期
						boolean isAfter = nextWeek.after(now);
						pageContext.setAttribute("isAfter", isAfter);
					%>
					<c:if test="${isAfter}">
						<c:choose>
							<c:when test="${expressSend.expressName=='shunfeng' && expressSend.printState=='0' && empty expressSend.otherExpressNo}">
								<shiro:hasPermission name="sys:expressSend:print">
									<a href="${ctx}/sys/expressSend/expressSendPrint?id=${expressSend.id}">打印</a>
								</shiro:hasPermission>
							</c:when>
							<c:when test="${expressSend.expressName=='shentong' && expressSend.printState=='0' }">
								<shiro:hasPermission name="sys:expressSend:print">
									<a href="${ctx}/sys/expressSend/expressPrint?id=${expressSend.id}">打印</a>
								</shiro:hasPermission>
							</c:when>

							<%-- TODO zhaoxy --%>
							<c:when test="${expressSend.expressName=='shunfeng' && expressSend.printState=='0' &&  not empty expressSend.otherExpressNo }">
								<shiro:hasPermission name="sys:expressSend:print">
									<a href="${ctx}/sys/expressSend/expressSendPrintSf?id=${expressSend.id}">顺丰打印</a>
								</shiro:hasPermission>
							</c:when>

							<c:when test="${expressSend.printState=='1' }">
								<shiro:hasPermission name="sys:expressSend:print">
									<a href="${ctx}/sys/expressSend/restPrint?id=${expressSend.id}">重置</a>
								</shiro:hasPermission>
							</c:when>
						</c:choose>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	<script type="text/javascript">
		function searchQueue(){
			parent.layer.open({
				type: 2,
				title: ['查询用户的待寄物品', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '530px'],
				content: "${ctx}/sys/expressQueue/search"
			});
			return false;
		}
		
		function reviewSfBill(id){
			parent.layer.open({
				type: 2,
				title: ['电子面单', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: true, //开启最大化最小化按钮
				area: ['600px', '700px'],
				content: "${ctx}/sys/expressSend/reviewSfBill?id=" + id 
			});
			return false;
		}
		
		function searchSFRoute(orderId){
			parent.layer.open({
				type: 2,
				title: ['物流信息', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: true, //开启最大化最小化按钮
				area: ['1000px', '600px'],
				content: "${ctx}/sys/expressSend/searchSFRoute?orderId=" + orderId 
			});
			return false;
		}
		
		
		function QueueCallback(ids,memberCode){
			if(memberCode != undefined){
				window.location.href="${ctx}/sys/expressSend/form?queueIds="+ids+"&memberCode="+memberCode;
			}else{
				window.location.href="${ctx}/sys/expressSend/form";
			}
		}
		
	</script>
</body>
</html>