<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展子表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

 			//回显裁判信息
 			var referee = '${fns:escapeHtml(mainShows.referee)}';
			var refereeArray = referee.split(",");
			$.each(refereeArray, function(i,val) {
				$("#referee").find("option[value='"+val+"']").attr("selected",true);
		    });
			$("#referee").trigger("change");


		});
		function addRow(list, idx, tpl, row){
			$(list).append(Mustache.render(tpl, {
				idx: idx, delBtn: true, row: row
			}));
			testDataChildRowIdx = testDataChildRowIdx + 1;
			$(list+idx).find("select").each(function(){
				$(this).val($(this).attr("data-value"));
			});
			$(list+idx).find("input[name='childShowsList["+idx+"].showRules'][value="+row.showRules+"]").attr("checked",true);
			$(list+idx).find("input[name='childShowsList["+idx+"].fee']").val(row.fee.substring(0,row.fee.length-3));
			$(list+idx).find("input[name='childShowsList["+idx+"].startTime']").val(row.startTime.substring(0,row.startTime.length-9));
			$(list+idx).find("input[name='childShowsList["+idx+"].endTime']").val(row.endTime.substring(0,row.endTime.length-9));
			$(list+idx).find("input[name='childShowsList["+idx+"].useCoupon'][value="+row.useCoupon+"]").attr("checked",true);
			$(list+idx).find("input[name='childShowsList["+idx+"].isDiscount'][value="+row.isDiscount+"]").attr("checked",true);
			$(list+idx).find("input[name='childShowsList["+idx+"].cacType'][value="+row.cacType+"]").attr("checked",true);
		}
		function delRow(obj, prefix){
			var id = $(prefix+"_id");
			var delFlag = $(prefix+"_delFlag");
			if (id.val() == ""){
				$(obj).parent().parent().remove();
			}else if(delFlag.val() == "0"){
				delFlag.val("1");
				$(obj).html("&divide;").attr("title", "撤销删除");
				$(obj).parent().parent().addClass("error");
			}else if(delFlag.val() == "1"){
				delFlag.val("0");
				$(obj).html("&times;").attr("title", "删除");
				$(obj).parent().parent().removeClass("error");
			}
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/show.child/childShows/">犬展列表</a></li>
		<shiro:hasPermission name="show.child:childShows:edit">
		<li class="active"><a href="${ctx}/show.child/childShows/add">录入犬展信息</a></li>
		</shiro:hasPermission>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="mainShows" action="${ctx}/show.child/childShows/saveMain" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>


			<div class="control-group">
				<label class="control-label">举办方式：</label>
				<div class="controls">
					<c:if test="${mainShows.orgnizeTypeAndModelFlag=='1'}">自办</c:if>
					<c:if test="${mainShows.orgnizeTypeAndModelFlag=='0'}">合办旧模式</c:if>
					<c:if test="${mainShows.orgnizeTypeAndModelFlag=='2'}">合办新模式</c:if>
					<c:if test="${mainShows.orgnizeTypeAndModelFlag=='3'}">合办新模式2025</c:if>
				</div>
			</div>
			<%--<c:if test="${mainShows.orgnizeType=='0'}">--%>
				<%--<div class="control-group">--%>
					<%--<label class="control-label">业务模式：</label>--%>
					<%--<div class="controls">--%>
							<%--${fns:getDictLabel(mainShows.businessModelFlag, 'business_model_flag', '')}--%>
					<%--</div>--%>
				<%--</div>--%>
			<%--</c:if>--%>

			<div class="control-group">
				<label class="control-label">主办单位：</label>
				<div class="controls">
					<c:choose>
                   		<c:when test="${mainShows.createDate!=null && mainShows.createDate.getTime()<organizerNewDate.getTime()}">
                   			${fns:getDictLabel(mainShows.organizer, 'show_organizer', '')}
                   		</c:when>
                   		<c:when test="${mainShows.createDate!=null && mainShows.createDate.getTime()<organizerNewDate2.getTime()&& mainShows.createDate.getTime()>=organizerNewDate.getTime()}">
                   			${fns:getDictLabel(mainShows.organizer, 'show_organizer_new', '')}
                   		</c:when>
                   		<c:otherwise>
                   			${fns:getDictLabel(mainShows.organizer, 'show_organizer_2023', '')}
                   		</c:otherwise>
                	</c:choose>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">承办单位：</label>
				<div class="controls">
						${fns:escapeHtml(mainShows.undertaker)}
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">报名结束日期：</label>
				<div class="controls">
					<fmt:formatDate value="${mainShows.closingTime}" pattern="yyyy-MM-dd HH:mm"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">犬展年份：</label>
				<div class="controls">
						${fns:escapeHtml(mainShows.year)}
				
				<font color="red">(该年份只在上传成绩时起效，统计积分榜时有疑问可在后台成绩列表中确认归属年份是否正确)</font>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">犬展报名：</label>
				<div class="controls">
					${fns:getDictLabel(mainShows.register, 'show_register', '')}
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">牵犬师头像校验：</label>
				<div class="controls">
					<c:if test="${mainShows.handlerPhotoFlag=='0'}">不校验</c:if>
					<c:if test="${mainShows.handlerPhotoFlag=='1'}">校验</c:if>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">犬只上限只数：</label>
				<div class="controls">
					${fns:escapeHtml(mainShows.dogNumMax)}
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">主犬展名称：</label>
				<div class="controls">
					${fns:escapeHtml(mainShows.mainShowName)}
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">犬展地点：</label>
				<div class="controls">
					${fns:escapeHtml(mainShows.showLocation)}
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">裁判：</label>
				<div class="controls">
	                <form:select id="referee" path="referee" disabled="true" class="input-xxlarge required" multiple="true">
	                	<form:options items="${showJudgeList}" itemLabel="judgeName" itemValue="id" htmlEscape="false"/>
	                </form:select>
				</div>
			</div>

            <div class="control-group">
              <label class="control-label">官网是否展示：</label>
                <div class="controls">
               		<c:if test="${mainShows.isShowWebsite=='0'}">展示</c:if>
					<c:if test="${mainShows.isShowWebsite=='1'}">不展示</c:if>
                </div>
            </div>
            <div class="control-group">
              <label class="control-label">是否置顶：</label>
                <div class="controls">
               		<c:if test="${mainShows.isTop=='0'}">不置顶</c:if>
					<c:if test="${mainShows.isTop=='1'}">置顶</c:if>
                </div>
            </div>

			<div class="control-group">
				<label class="control-label">子犬展信息：</label>
				<div class="controls">
					<table id="contentTable" class="table table-striped table-bordered table-condensed">
						<thead>
							<tr>
								<th class="hide"></th>
								<th>犬展编号</th>
								<th>犬展名称</th>
								<th>规则</th>
								<th>报名费</th>
								<th>开始时间</th>
								<th>结束时间</th>
								<th>是否使用优惠卷</th>
								<th>是否参与满减</th>
								<th>CAC类型</th>
								<shiro:hasPermission name="show.child:childShows:edit">
								<th width="10">&nbsp;</th>
								</shiro:hasPermission>
							</tr>
						</thead>
						<tbody id="testDataChildList">
						</tbody>
					</table>
					<script type="text/template" id="testDataChildTpl">//<!--
						<tr id="testDataChildList{{idx}}">
							<td class="hide">
								<input id="testDataChildList{{idx}}_id" name="childShowsList[{{idx}}].id" type="hidden" value="{{row.id}}"/>
								<input id="testDataChildList{{idx}}_delFlag" name="childShowsList[{{idx}}].delFlag" type="hidden" value="0"/>
							</td>
							<td>
								{{row.showCode}}
							</td>
							<td>
								{{row.showName}}
							</td>
							<td>
								<span>
									<input id="mainShows.orgnizeType1" disabled name="childShowsList[{{idx}}].showRules" class="required" type="radio" value="0"/>
									<label for="mainShows.orgnizeType1">全犬种</label>
								</span>
								<span>
									<input id="mainShows.orgnizeType2" disabled name="childShowsList[{{idx}}].showRules" class="required" type="radio" value="1"/>
									<label for="mainShows.orgnizeType2">单独展</label>
								</span>
							</td>
							<td>
								{{row.fee}}
							</td>
							<td>
								{{row.startTime}}
							</td>
							<td>
								{{row.endTime}}
							</td>
							<td>
								<span>
									<input disabled name="childShowsList[{{idx}}].useCoupon" class="required" type="radio" value="0"/>
									<label>是</label>
								</span>
								<span>
									<input disabled name="childShowsList[{{idx}}].useCoupon" class="required" type="radio" value="1"/>
									<label>否</label>
								</span>
							</td>

							<td>
								<span>
									<input disabled name="childShowsList[{{idx}}].isDiscount" class="required" type="radio" value="0"/>
									<label>是</label>
								</span>
								<span>
									<input disabled name="childShowsList[{{idx}}].isDiscount" class="required" type="radio" value="1"/>
									<label>否</label>
								</span>
							</td>
							<td>
								<span>
									<input disabled name="childShowsList[{{idx}}].cacType" class="required" type="radio" value="0"/>
									<label>CAC</label>
								</span>
								<span>
									<input disabled name="childShowsList[{{idx}}].cacType" class="required" type="radio" value="1"/>
									<label>CACIB</label>
								</span>
							</td>
							<shiro:hasPermission name="test:testDataMain:edit"><td class="text-center" width="10">
								{{#delBtn}}<span class="close" onclick="delRow(this, '#testDataChildList{{idx}}')" title="删除">&times;</span>{{/delBtn}}
							</td></shiro:hasPermission>
						</tr>//-->
					</script>
					<script type="text/javascript">
						var testDataChildRowIdx = 0, testDataChildTpl = $("#testDataChildTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g,"");
						$(document).ready(function() {
							var data = ${fns:toJson(mainShows.childShowsList)};
							console.log(data);
							for (var i=0; i<data.length; i++){
								addRow('#testDataChildList', testDataChildRowIdx, testDataChildTpl, data[i]);
							}
						});
					</script>
				</div>
			</div>


		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
			<button class="btn" onclick="util.showLog('/oa-web/oaManage/show.child/childShows','${mainShows.id}');return false;">查看操作日志</button>
		</div>


	</form:form>
</body>
</html>