<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>俱乐部账户</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/shop/shopMember/moneyList">俱乐部账户收支信息</a></li>
		<li class="active"><a href="${ctx}/shop/shopMember/list">俱乐部账户</a></li>
		<shiro:hasPermission name="shop:shopMember:recharge">
			<li><a href="${ctx}/shop/shopMember/form">俱乐部充值</a></li>
			<li><a href="${ctx}/shop/shopMember/refund">俱乐部退款</a></li>
		</shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="shopMember" action="${ctx}/shop/shopMember/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>名称</th>
				<th>余额</th>
				<th>返利</th>
				<th>本金销售总额</th>
				<th>返利销售总额</th>
				<th>详情</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="shopMember">
			<tr>
				<td>
					${fns:escapeHtml(shopMember.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(shopMember.orgName)}
				</td>
				<td>
					${fns:escapeHtml(shopMember.userMoney)}
				</td>
				<td>
					${fns:escapeHtml(shopMember.rebateMoney)}
				</td>
				<td>
					${fns:escapeHtml(shopMember.userCountMoney)}
				</td>
				<td>
					${fns:escapeHtml(shopMember.rebateCountMoney)}
				</td>
				<td>
					<a href="${ctx}/shop/shopMember/detail?memberCode=${shopMember.memberCode}">详情</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>