<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商品类别管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/shop/shopGoodsClass/">商品类别列表</a></li>
		<li class="active"><a href="${ctx}/shop/shopGoodsClass/form?id=${shopGoodsClass.id}&parent.id=${shopGoodsClassparent.id}">商品类别<shiro:hasPermission name="shop:shopGoodsClass:${not empty shopGoodsClass.id?'edit':'add'}">${not empty shopGoodsClass.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="shop:shopGoodsClass:${not empty shopGoodsClass.id?'edit':'add'}">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="shopGoodsClass" action="${ctx}/shop/shopGoodsClass/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">类别名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">类别缩写：</label>
			<div class="controls">
				<form:input path="shortName" htmlEscape="false" maxlength="10" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品类别:</label>
			<div class="controls">
				<sys:treeselect id="parent" name="parent.id" value="${shopGoodsClass.parent.id}" labelName="parent.name" labelValue="${shopGoodsClass.parent.name}"
					title="商品类别" url="/shop/shopGoodsClass/treeData" extId="${shopGoodsClass.id}" cssClass="" allowClear="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">序号：</label>
			<div class="controls">
				<form:input path="sort" htmlEscape="false" maxlength="10" class="input-xlarge  digits"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="shop:shopGoodsClass:${not empty shopGoodsClass.id?'edit':'add'}"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>