<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>采样包日志管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/samplingFlowLog/samplingFlowLog/">采样包日志列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="samplingFlowLog" action="${ctx}/samplingFlowLog/samplingFlowLog/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>采样包编号：</label>
				<form:input path="samplingCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>流程类型：</label>
				<form:select path="flowType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('sampling_log_flow_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>操作信息：</label>
				<form:input path="operData" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>采样包编号</th>
				<th>流程类型</th>
				<th>操作信息</th>
				<th>创建者</th>
				<th>创建时间</th>
				<th>备注信息</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="samplingFlowLog">
			<tr>
				<td>
					<a href="${ctx}/samplingFlowLog/samplingFlowLog/viewForm?id=${samplingFlowLog.id}">
							${samplingFlowLog.samplingCode}
					</a>
				</td>
				<td>
					${fns:getDictLabel(samplingFlowLog.flowType, 'sampling_log_flow_type', '')}
				</td>
				<td>
					${samplingFlowLog.operData}
				</td>
				<td>
					${samplingFlowLog.operName}
				</td>
				<td>
					<fmt:formatDate value="${samplingFlowLog.operTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${samplingFlowLog.remarks}
				</td>
				<td>
					<shiro:hasPermission name="sampling:samplingFlowLog:edit">
						<a href="${ctx}/samplingFlowLog/samplingFlowLog/editForm?id=${samplingFlowLog.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="sampling:samplingFlowLog:del">
						<a href="${ctx}/samplingFlowLog/samplingFlowLog/delete?id=${samplingFlowLog.id}"
						   onclick="return confirmx('确认要删除该采样包流程日志吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>