<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍所有人变更管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function auditForm(id){
			parent.layer.open({
				type: 2,
				title: ['犬舍所有人变更审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['550px', '350px'],
				content: "${ctx}/kennel/kennelOwnerChange/auditForm?id="+id,
				end:function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/kennel/kennelOwnerChange/">犬舍所有人变更列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="kennelOwnerChange" action="${ctx}/kennel/kennelOwnerChange/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>犬舍名称：</label>
				<form:input path="kennel.name" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="originOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
			<label>申请日期：&nbsp;</label><input id="beginDate" name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="<fmt:formatDate value="${kennelOwnerChange.beginDate}" pattern="yyyy-MM-dd"/>" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			<label>&nbsp;--&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label><input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="<fmt:formatDate value="${kennelOwnerChange.endDate}" pattern="yyyy-MM-dd"/>" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬舍中文名</th>
				<th>犬舍英文名</th>
				<th>犬舍原主人</th>
				<th>犬舍新主人</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>处理</th>
				<!-- <th>打印</th> -->
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="kennelOwnerChange">
			<tr>
				<td>
					${fns:escapeHtml(kennelOwnerChange.kennel.name)}
				</td>
				<td>
					${fns:escapeHtml(kennelOwnerChange.kennel.nameEn)}
				</td>
				<td title="${fns:escapeHtml(kennelOwnerChange.originOwnerMemberCode)}">
					${fns:escapeHtml(kennelOwnerChange.member1.name)}
				</td>
				<td title="${fns:escapeHtml(kennelOwnerChange.newOwnerMemberCode)}">
					${fns:escapeHtml(kennelOwnerChange.member2.name)}
				</td>
				<td>
					<fmt:formatDate value="${kennelOwnerChange.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:if test="${'1' eq kennelOwnerChange.paymentState}">
						<font color="red">${fns:getDictLabel(kennelOwnerChange.paymentState, 'user_payment_state', '')}</font>
					</c:if>
					<c:if test="${'2' eq kennelOwnerChange.paymentState}">
						<font color="green">${fns:getDictLabel(kennelOwnerChange.paymentState, 'user_payment_state', '')}</font>
					</c:if>
				</td>				
				<%-- <shiro:hasPermission name="kennel:kennelOwnerChange:audit"> --%>
				<td>
					<c:if test="${'0' eq kennelOwnerChange.reviewState}">
						<c:if test="${'1' eq kennelOwnerChange.paymentState}">
							<font color="red">${fns:getDictLabel(kennelOwnerChange.reviewState, 'review_state', '')}</font>
						</c:if>
						<c:if test="${'2' eq kennelOwnerChange.paymentState}">
							<a href="#" onclick="auditForm('${fns:escapeHtml(kennelOwnerChange.id)}')">
								<font color="red">${fns:getDictLabel(kennelOwnerChange.reviewState, 'review_state', '')}</font>
							</a> 
						</c:if>
					</c:if>
					<c:if test="${'1' eq kennelOwnerChange.reviewState}">
						${fns:getDictLabel(kennelOwnerChange.reviewState, 'review_state', '')}
					</c:if>
					<c:if test="${'2' eq kennelOwnerChange.reviewState || '3' eq kennelOwnerChange.reviewState}">
						<a title="${fns:escapeHtml(kennelOwnerChange.reviewRemarks)}">${fns:getDictLabel(kennelOwnerChange.reviewState, 'review_state', '')}</a>
					</c:if>
				</td>
				<td>
					<c:choose>
						<c:when test="${'1' eq kennelOwnerChange.processState}">
							<font color="green">${fns:getDictLabel(kennelOwnerChange.processState, 'proccess_state', '')}</font>
						</c:when>
						<c:when test="${'2' eq kennelOwnerChange.paymentState and '1' eq kennelOwnerChange.reviewState and not empty  kennelOwnerChange.kennel.name}">
						 	<a href="${ctx}/kennel/kennelOwnerChange/resolve?id=${kennelOwnerChange.id}" onclick="return confirmx('确认要处理该犬舍所有人变更吗？', this.href)">
								<font color="red">处理</font>
							</a> 
						</c:when>
					</c:choose>
				</td>
				<!-- <td>
					<c:choose>
						<c:when test="${kennelOwnerChange.kennel.printState=='0' &&kennelOwnerChange.paymentState=='2'&&kennelOwnerChange.reviewState=='1'&&kennelOwnerChange.processState=='1'  }">
							<shiro:hasPermission name="kennel:kennel:print">
								<a href="${ctx}/kennel/kennel/print?id=${kennelOwnerChange.kennel.id}">打印</a>&nbsp;&nbsp;
							</shiro:hasPermission>
						</c:when>
						<c:when test="${kennelOwnerChange.kennel.printState=='1' &&kennelOwnerChange.paymentState=='2'&&kennelOwnerChange.reviewState=='1'&&kennelOwnerChange.processState=='1'  }">
							<shiro:hasPermission name="kennel:kennel:resetPrint">
								<a href="${ctx}/kennel/kennel/resetPrint?id=${kennelRename.kennel.id}&tz=1">重置打印</a>&nbsp;&nbsp;
							</shiro:hasPermission>
							<shiro:lacksPermission name="kennel:kennel:resetPrint">
								已打印
							</shiro:lacksPermission>
						</c:when>
						<c:when test="${kennelOwnerChange.kennel.fciPrintState=='0' &&kennelOwnerChange.paymentState=='2'&&kennelOwnerChange.reviewState=='1'&&kennelOwnerChange.processState=='1'  }">
							<shiro:hasPermission name="kennel:kennel:print">
								<a href="${ctx}/kennel/kennel/fciPrint?id=${kennelRename.kennel.id}">打印</a>&nbsp;&nbsp;
							</shiro:hasPermission>
						</c:when>
						<c:when test="${kennelOwnerChange.kennel.fciPrintState=='1' &&kennelOwnerChange.paymentState=='2'&&kennelOwnerChange.reviewState=='1'&&kennelOwnerChange.processState=='1'  }">
							<shiro:hasPermission name="kennel:kennel:resetPrint">
							<a href="${ctx}/kennel/kennel/fciResetPrint?id=${kennelRename.kennel.id}&tz=1">重置打印</a>&nbsp;&nbsp;
							</shiro:hasPermission>
							<shiro:lacksPermission name="kennel:kennel:resetPrint">
								已打印
							</shiro:lacksPermission>
						</c:when>
					</c:choose>
					<a href="#" onclick="window.print()">打印</a>
				</td> -->
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>