<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名信息</title>
	<meta name="decorator" content="default"/>
	<style>
		#select2-drop{
			z-index: 99999999;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#reviewDiv").hide();
		});
		function review() {
			var reviewDiv = $("#reviewDiv");
			layer.open({
				type: 1,
				title: "课程审核",
				shadeClose: true,
				skin:'to-fix-select',
				area: ['500px', '300px'],
				content: reviewDiv
				,btn: ['确定', '取消']
				,yes: function(index){
					var states = $("#states").val();
					var reviewRemarks = $("#reviewRemarks").val();
					if(states =='4' && reviewRemarks == ''){
						alert("审核不通过请注明原因");
						return;
					}
					$("#inputForm").submit();
				}
			});
		}
		function lookPhoto(photoId){
			layer.open({
				type: 1,
				title: "图片",
				shadeClose: true,
				area: ['500px', '550px'],
				content: '<img height:500px;width:500px" src="${pageContext.request.contextPath}/api/v1/open/image/'+photoId+'">',
			});
		}
		function lookPhotoAvatar(photoId){
			layer.open({
				type: 1,
				title: "图片",
				shadeClose: true,
				area: ['500px', '550px'],
				content: '<img height:500px;width:500px" src="${pageContext.request.contextPath}/schools/file/image/'+photoId+'">',
			});
		}
	</script>

	<!--引入wangEditor.css-->
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active">课程查看</li>
</ul><br/>
<form:form id="inputForm" modelAttribute="groomerCourse" action="${ctx}/groomer/groomerCourse/saveReview" class="form-horizontal">
	<form:hidden path="id"/>
	<sys:message content="${message}"/>
	<div id="reviewDiv">
		<div class="control-group" id="statesDiv">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="states" class="input-medium">
					<form:option value="2" label="待审核"/>
					<form:option value="3" label="审核通过"/>
					<form:option value="4" label="审核不通过"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核原因：</label>
			<div class="controls">
				<form:textarea  htmlEscape="true" path="reviewRemarks" rows="4"   placeholder="审核不通过请注明原因 " />
			</div>
		</div>
	</div>


<h2>课程报名信息</h2>
	<div class="control-group">
		<label class="control-label">课程编号：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourse.code)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程名称：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourse.courseName)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程类型：</label>
		<div class="controls">
				${fns:getDictLabel(groomerCourse.type, 'course_type', '')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程等级：</label>
		<div class="controls">
				${fns:getDictLabel(groomerCourse.diplomaLevel, 'course_level', '')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程价格：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourse.price)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">报名时间：</label>
		<div class="controls">
			<fmt:formatDate value="${groomerCourse.registrationStarteTime}" pattern="yyyy-MM-dd"/>-<fmt:formatDate value="${groomerCourse.registrationEndTime}" pattern="yyyy-MM-dd"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">培训时间：</label>
		<div class="controls">
			<fmt:formatDate value="${groomerCourse.startDate}" pattern="yyyy-MM-dd"/>-<fmt:formatDate value="${groomerCourse.endDate}" pattern="yyyy-MM-dd"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程状态：</label>
		<div class="controls">
				${fns:getDictLabel(groomerCourse.states, 'course_states', '')}
		</div>
	</div>
	<h2>课程详情</h2>
	<div class="control-group">
		<label class="control-label">讲师姓名：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourse.teacher) }
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">授课等级：</label>
		<div class="controls">
				${fns:escapeHtml(teacherLecturer.level)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">讲师头像：</label>
		<div class="controls">
			<img  style="width:180px; height: 190px"src="${pageContext.request.contextPath}/api/v1/open/image2/${teacherLecturer.avatar}" onclick="lookPhotoAvatar('${teacherLecturer.avatar}')">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">讲师介绍：</label>
		<div class="controls">
				${fns:escapeHtml(teacherLecturer.introduce)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程封面图：</label>
		<div class="controls">
			<img  style="width:180px; height: 190px"src="${pageContext.request.contextPath}/api/v1/open/image2/${groomerCourse.cover}" onclick="lookPhoto('${groomerCourse.cover}')">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程介绍图：</label>
		<div class="controls">
			<c:if test="${not empty groomerCourse.introduce}">
				<img  style="width:180px; height: 190px"src="${pageContext.request.contextPath}/api/v1/open/image/${groomerCourse.pic1}" onclick="lookPhoto('${groomerCourse.pic1}')">
				<img  style="width:180px; height: 190px"src="${pageContext.request.contextPath}/api/v1/open/image/${groomerCourse.pic2}" onclick="lookPhoto('${groomerCourse.pic2}')">
				<img  style="width:180px; height: 190px"src="${pageContext.request.contextPath}/api/v1/open/image/${groomerCourse.pic3}" onclick="lookPhoto('${groomerCourse.pic3}')">
			</c:if>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程视频：</label>
		<div class="controls">
			<c:if test="${not empty groomerCourse.videoUrl }">
				<video id="videoUrl"  src="${groomerCourse.videoUrl}" controls="controls"></video>
			</c:if>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程介绍：</label>
		<div class="controls">
			<form:textarea path="courseDetails" style="height:400px" disabled="true"  htmlEscape="true" readonly="true"></form:textarea>
		</div>
	</div>
	<script type="text/javascript" src="${ctxStatic }/wangEditor/js/wangEditor.min.js"></script>
	<script type="text/javascript">
		var editor = new wangEditor('courseDetails');
		// 上传图片（举例）
		editor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';

		editor.config.uploadImgFileName = 'editorImg';
		// 设置 headers（举例）
		editor.config.uploadHeaders = {
			'Accept' : 'text/x-json'
		};

		// 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
		editor.config.hideLinkImg = true;
		editor.create();
	</script>

	<div class="form-actions">
		<c:if test='${groomerCourse.states == 3 || groomerCourse.states == 2}'>
			<input id="reviewBtn" class="btn btn-primary" type="button" value="审核" onclick="review()"/>
		</c:if>
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>