<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商品管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/goods/sku/">商品列表</a></li>
		<shiro:hasPermission name="goods:sku:add"><li><a href="${ctx}/goods/sku/editForm">商品添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="sku" action="${ctx}/goods/sku/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>业务名称：</label>
				<form:input path="businessName" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>商品名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>销售标记：</label>
				<form:select path="saleFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('on_off_sale')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>退款标记：</label>
				<form:select path="refundFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>业务名称</th>
				<th>商品名称</th>
				<th>金额</th>
				<th>销售标记</th>
				<th>退款标记</th>
				<th>排序</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="sku">
			<tr>
				<td>
					${sku.businessName}
				</td>
				<td>
					${sku.name}
				</td>
				<td>
					${sku.price}
				</td>
				<td>
					${fns:getDictLabel(sku.saleFlag, 'on_off_sale', '')}
				</td>
				<td>
					${fns:getDictLabel(sku.refundFlag, 'yes_no', '')}
				</td>
				<td>
						${sku.sort}
				</td>
				<td>
					<a href="${ctx}/goods/sku/viewForm?id=${sku.id}">查看</a>
					<shiro:hasPermission name="goods:sku:edit">
						<a href="${ctx}/goods/sku/editForm?id=${sku.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="goods:sku:del">
						<a href="${ctx}/goods/sku/delete?id=${sku.id}"
						   onclick="return confirmx('确认要删除该商品吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>