<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body >
	<div style="padding:10px;">
	<form:form id="searchForm" modelAttribute="memberAccount" action="${ctx}/finance/memberAccount/" method="post" class="breadcrumb form-search" >
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<input id="searcheType" name="searcheType" type="hidden" value="1"/>
		<ul class="ul-form">
			<li><label>流水编号：</label>
				<form:input path="runningNumber" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>	
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>流水号</th>
				<th>会员号姓名</th>
				<th>姓名</th>
				<th>金额</th>
				<th>收支类型</th>
				<th>支付方式</th>
				<th>缴费时间</th>
				<shiro:hasPermission name="sys:user:member:edit"><th>选择</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:if test="${page.count == 0 }">
		<tr> <td colspan="8">没有找到任何信息，请输入流水号</td></tr></c:if>
		<c:forEach items="${page.list}" var="memberAccount">
			<tr>
				<td>
						${fns:escapeHtml(memberAccount.runningNumber)}
				</td>
				<td>
						${fns:escapeHtml(memberAccount.memberCode)}
				</td>
				<td>
						${fns:escapeHtml(memberAccount.memberName)}
				</td>
				<td>
						${fns:escapeHtml(memberAccount.paymentAmount)}
				</td>
				<td>
						${fns:escapeHtml(memberAccount.chargingItemName)}
				</td>
				<td>
						${fns:getDictLabel(memberAccount.paymentWay, 'payment_way', '')}
				</td>
				<td>
					<fmt:formatDate value="${memberAccount.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
    					<a href="#" onclick="select('${fns:escapeHtml(memberAccount.paymentAmount)}','${fns:escapeHtml(memberAccount.runningNumber)}','${fns:escapeHtml(memberAccount.memberCode) }','${fns:escapeHtml(memberAccount.memberName)}','${member.gender}','${member.paymentState}','${member.memberType}','${member.accountBalance}','${fns:escapeHtml(member.mobile)}','${fns:escapeHtml(member.phone)}','${fns:escapeHtml(member.avatar) }','${fns:escapeHtml(member.province)}','${fns:escapeHtml(member.city)}','${fns:escapeHtml(member.street)}','${member.postcode }','${fns:escapeHtml(member.deliveryCertified) }')">选择</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	</div>
	<script type="text/javascript">
		function select(paymentAmount,runingNumber,memberCode,name,gender,paymentState,memberType,accountBalance,mobile,phone,avatar,province,city,street,postcode,deliveryCertified){
			var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
			var member = {
					paymentAmount:paymentAmount,
					runingNumber:runingNumber,
					memberCode:memberCode,
					name:name,
					gender:gender,
					paymentState:paymentState,
					memberType:memberType,
					accountBalance:accountBalance,
					mobile:mobile,
					phone:phone,
					avatar:avatar,
					province:province,
					city:city,
					street:street,
					postcode:postcode,
					deliveryCertified:deliveryCertified
			}
			if(parent.document.getElementById("mainFrame").contentWindow.searchUserCallback != undefined){
				parent.document.getElementById("mainFrame").contentWindow.searchUserCallback(member);
			}
			parent.layer.close(index);
		}
	</script>
</body>
</html>