<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>藏獒犬只鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			if($("#reviewState").val()==2){
                $("#reviewDiv").show();
            } else {
                $("#reviewDiv").hide();
            }
			
			/* var b="${not empty dogTibetanMastiff.id?'1':'0'}";
			if (b==1) {
				$("#dogOwner").attr("disabled","false");
				$("#memberCode").attr("disabled","false");
			} */
			
		});
		function changeState(val){
            if(val==2){
                $("#reviewDiv").show();
            } else {
                $("#reviewDiv").hide();
                $("#reviewRemarks").val('');
            }
        }
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/">藏獒犬只鉴定列表</a></li>
		<li class="active"><a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/form?id=${dogTibetanMastiff.id}">藏獒犬只鉴定<shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:${not empty dogTibetanMastiff.id?'edit':'add'}">${not empty dogTibetanMastiff.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dogtibetanmastiff:dogTibetanMastiff:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogTibetanMastiff" action="${ctx}/dogtibetanmastiff/dogTibetanMastiff/${not empty dogTibetanMastiff.id?'save':'add'}" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode"  htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
				<input id="selectMember" class="btn btn-primary" value="查询" type="button" onclick="searchUser()"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主姓名：</label>
			<div class="controls">
				<form:input path="dogOwner" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只名称：</label>
			<div class="controls">
				<form:input path="dogName" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">犬只性别：</label>
            <div class="controls">
                <form:radiobuttons path="gender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class=""/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">犬只生日：</label>
			<div class="controls">
				<input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogTibetanMastiff.birthdate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只毛色：</label>
			<div class="controls">
				<form:input path="colorFlag" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">备注信息：</label>
            <div class="controls">
                <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
            </div>
        </div>
		<div class="form-actions">
			<shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:${not empty dogTibetanMastiff.id?'edit':'add'}"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script type="text/javascript">
	//打开查询用户的弹窗
	function searchUser(){
		top.layer.open({
			type: 2,
			title: ['会员查询', 'font-size:18px;text-align: center;'],
			shadeClose: false,
			shade: [0.8, '#393D49'],
			maxmin: false, //开启最大化最小化按钮
			area: ['700px', '500px'],
			content: "${ctx}/sys/user/member/search"
		});
	}
	
	//查询用户完成的回调方法
	this.searchUserCallback = function (json){
		$("#memberCode").val(json.memberCode);
		$("#dogOwner").val(json.name);
	}
	
</script>
</body>
</html>