<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬主变更申请管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
            $(document).tooltip();
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
			    <th>血统证书号</th>
				<th>原犬主姓名</th>
				<th>新犬主姓名</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<shiro:hasPermission name="dogownerchange:dogOwnerChange:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogOwnerChange">
			<tr>
			    <td>
			        ${fns:escapeHtml(dogOwnerChange.dog.pedigreeCertifiedCode) }
			    </td>
				<td style="color:#000" title="${fns:escapeHtml(dogOwnerChange.originOwnerMemberCode) }">
					${fns:escapeHtml(dogOwnerChange.originOwnerName) }
				</td >
				<td style="color:#000" title="${fns:escapeHtml(dogOwnerChange.newOwnerMemberCode) }">
					${fns:escapeHtml(dogOwnerChange.newOwnerName) }
				</td>
				<td>
                    <fmt:formatDate value="${dogOwnerChange.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
                <td>
                    <c:if test="${dogOwnerChange.paymentState==1}"><font color="red">${fns:getDictLabel(dogOwnerChange.paymentState, 'user_payment_state', '')}</font></c:if>
                    <c:if test="${dogOwnerChange.paymentState==2}"><font color="green">${fns:getDictLabel(dogOwnerChange.paymentState, 'user_payment_state', '')}</font></c:if>
                </td>
				<shiro:hasPermission name="dogownerchange:dogOwnerChange:delete">
				<td>
				 	<c:if test="${!dogOwnerChange.businessRefundState}">
                			<a href="${ctx}/dogownerchange/dogOwnerChange/orderDelete?id=${dogOwnerChange.id}" onclick="return confirmx('确认要删除该犬主变更申请吗？', this.href)">删除</a>
               	 	</c:if>
				</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>