<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>种犬申报管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#semenDiv").hide();
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });

        function changeReviewState() {
            var reviewState = $('#reviewState').val();
            if (reviewState == '1') {
                $("#semenDiv").show();
            } else if (reviewState == '0') {
                $("#semenDiv").hide();
            }
        }

        function changeNum() {
            var num = $('#num').val();
            var html = '';
            for (var i = 0; i < num; i++) {
                html += '<input name="originalSemenCode[' + i + ']" class="input-xxlarge required"></br>';
            }
            $("#originalSemenCodeInput").html(html);
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/dogfrozensemen/dogFrozenSemen/list?businessType=0">种犬申报列表</a></li>
    <li class="active"><a href="${ctx}/dogfrozensemen/dogFrozenSemen/form?id=${dogFrozenSemen.id}">种犬申报审核</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="dogFrozenSemen" action="${ctx}/dogfrozensemen/dogFrozenSemen/audit0"
           method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">血统证书号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.pedigreeCertifiedCode) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号码：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.identificationFlag) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬种：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.breedCnName) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬名：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.nameEn) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬主：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.dogOwner) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬主会员号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.memberCode) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">处理状态：</label>
        <div class="controls">
            <form:select id="reviewState" path="reviewState" class="input-medium" onchange="changeReviewState()">
                <option value="0">待采集</option>
                <option value="1">通过</option>
            </form:select>
        </div>
    </div>
    <div id="semenDiv">
        <div class="control-group">
            <label class="control-label">精子数量：</label>
            <div class="controls">
                <input id="num" onchange="changeNum()" class="input-small required">管
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">原精液编号：</label>
            <div class="controls" id="originalSemenCodeInput">
            </div>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="dogfrozensemen:dogFrozenSemen:audit"><input id="btnSubmit" class="btn btn-primary"
                                                                               type="submit"
                                                                               value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>